/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.iam.apis;

import com.google.gson.annotations.SerializedName;
import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.util.Json;

public class ApiModifyGroup
extends Api {
    public ApiModifyGroup(Client client) {
        super(client);
    }

    public ApiModifyGroup(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static class Response
    extends Api.Response {
        private ModifyGroupResp data;

        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
            this.data = Json.decode(response.bodyString(), ModifyGroupResp.class);
        }

        public ModifyGroupResp getData() {
            return this.data;
        }

        public static final class ModifyGroupResp {
            @SerializedName(value="data")
            private ModifyGroupData data;

            public ModifyGroupData getData() {
                return this.data;
            }
        }

        public static final class ModifyGroupData {
            @SerializedName(value="id")
            private String id;
            @SerializedName(value="root_uid")
            private Integer rootUid;
            @SerializedName(value="alias")
            private String alias;
            @SerializedName(value="description")
            private String description;
            @SerializedName(value="enabled")
            private Boolean enabled;
            @SerializedName(value="created_at")
            private String createdAt;
            @SerializedName(value="updated_at")
            private String updatedAt;

            public String getId() {
                return this.id;
            }

            public Integer getRootUid() {
                return this.rootUid;
            }

            public String getAlias() {
                return this.alias;
            }

            public String getDescription() {
                return this.description;
            }

            public Boolean getEnabled() {
                return this.enabled;
            }

            public String getCreatedAt() {
                return this.createdAt;
            }

            public String getUpdatedAt() {
                return this.updatedAt;
            }
        }
    }

    public static class Request
    extends Api.Request {
        private String alias;
        private ModifyGroupParam data;

        public Request(String urlPrefix, String alias, ModifyGroupParam data) {
            super(urlPrefix);
            this.setMethod(MethodType.PATCH);
            this.setAuthType(1);
            this.alias = alias;
            this.data = data;
        }

        @Override
        protected void prepareToRequest() throws QiniuException {
            if (this.alias == null) {
                throw new QiniuException(new NullPointerException("alias can't empty"));
            }
            if (this.data == null) {
                throw new QiniuException(new NullPointerException("data can't empty"));
            }
            super.prepareToRequest();
        }

        @Override
        protected void buildPath() throws QiniuException {
            this.addPathSegment("iam/v1/groups");
            this.addPathSegment(this.alias);
            super.buildPath();
        }

        @Override
        protected void buildQuery() throws QiniuException {
            super.buildQuery();
        }

        @Override
        protected void buildHeader() throws QiniuException {
            super.buildHeader();
        }

        @Override
        protected void buildBodyInfo() throws QiniuException {
            byte[] body = Json.encode(this.data).getBytes(Constants.UTF_8);
            this.setBody(body, 0, body.length, "application/json");
            super.buildBodyInfo();
        }

        public static final class ModifyGroupParam {
            @SerializedName(value="alias")
            private String newAlias;
            @SerializedName(value="description")
            private String description;

            public ModifyGroupParam setNewAlias(String newAlias) {
                this.newAlias = newAlias;
                return this;
            }

            public ModifyGroupParam setDescription(String description) {
                this.description = description;
                return this;
            }
        }
    }
}

