/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.google.gson.Gson;
import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.ConfigHelper;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Recorder;
import com.qiniu.storage.ResumeUploadSource;
import com.qiniu.storage.UploadOptions;
import com.qiniu.storage.UploadToken;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import java.io.IOException;

abstract class ResumeUploadPerformer {
    final Client client;
    private final Recorder recorder;
    private final Configuration config;
    private final ConfigHelper configHelper;
    final String key;
    final UploadToken token;
    final ResumeUploadSource uploadSource;
    final UploadOptions options;

    ResumeUploadPerformer(Client client, String key, UploadToken token, ResumeUploadSource source, Recorder recorder, UploadOptions options, Configuration config) {
        this.client = client;
        this.key = key;
        this.token = token;
        this.uploadSource = source;
        this.options = options == null ? UploadOptions.defaultOptions() : options;
        this.recorder = recorder;
        this.config = config;
        this.configHelper = new ConfigHelper(config);
    }

    boolean isAllBlocksUploadingOrUploaded() {
        return this.uploadSource.isAllBlocksUploadingOrUploaded();
    }

    boolean isAllBlocksUploaded() {
        return this.uploadSource.isAllBlocksUploaded();
    }

    abstract boolean shouldUploadInit();

    abstract Response uploadInit() throws QiniuException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response uploadNextData() throws QiniuException {
        ResumeUploadSource.Block block = null;
        Object object = this;
        synchronized (object) {
            block = this.getNextUploadingBlock();
            if (block != null) {
                block.isUploading = true;
            }
        }
        if (block == null) {
            return Response.createSuccessResponse();
        }
        try {
            object = this.uploadBlock(block);
            return object;
        }
        finally {
            block.isUploading = false;
        }
    }

    abstract Response uploadBlock(ResumeUploadSource.Block var1) throws QiniuException;

    abstract Response completeUpload() throws QiniuException;

    private ResumeUploadSource.Block getNextUploadingBlock() throws QiniuException {
        ResumeUploadSource.Block block = null;
        try {
            block = this.uploadSource.getNextUploadingBlock();
        }
        catch (IOException e) {
            throw new QiniuException(e);
        }
        return block;
    }

    void recoverUploadProgressFromLocal() {
        if (this.recorder == null || StringUtils.isNullOrEmpty(this.uploadSource.recordKey)) {
            return;
        }
        byte[] data = this.recorder.get(this.uploadSource.recordKey);
        if (data == null) {
            return;
        }
        String jsonString = new String(data, Constants.UTF_8);
        ResumeUploadSource source = null;
        try {
            source = (ResumeUploadSource)new Gson().fromJson(jsonString, this.uploadSource.getClass());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (source == null) {
            return;
        }
        boolean isCopy = this.uploadSource.recoverFromRecordInfo(source);
        if (!isCopy) {
            this.removeUploadProgressFromLocal();
        }
    }

    void saveUploadProgressToLocal() {
        if (this.recorder == null || StringUtils.isNullOrEmpty(this.uploadSource.recordKey)) {
            return;
        }
        String dataString = new Gson().toJson((Object)this.uploadSource);
        this.recorder.set(this.uploadSource.recordKey, dataString.getBytes(Constants.UTF_8));
    }

    void removeUploadProgressFromLocal() {
        if (this.recorder == null || StringUtils.isNullOrEmpty(this.uploadSource.recordKey)) {
            return;
        }
        this.recorder.del(this.uploadSource.recordKey);
    }

    private String getUploadHost() throws QiniuException {
        return this.configHelper.upHost(this.token.getToken());
    }

    private void changeHost(String host) {
        try {
            this.configHelper.tryChangeUpHost(this.token.getToken(), host);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Response post(String url, byte[] data, int offset, int size) throws QiniuException {
        StringMap header = new StringMap();
        header.put("Authorization", "UpToken " + this.token.getToken());
        return this.client.post(url, data, offset, size, header, this.options.mimeType);
    }

    Response put(String url, byte[] data, int offset, int size) throws QiniuException {
        StringMap header = new StringMap();
        header.put("Authorization", "UpToken " + this.token.getToken());
        return this.client.put(url, data, offset, size, header, this.options.mimeType);
    }

    Response retryUploadAction(UploadAction action) throws QiniuException {
        Response response = null;
        int retryCount = 0;
        while (true) {
            String host;
            boolean shouldRetry;
            boolean shouldSwitchHost;
            block7: {
                shouldSwitchHost = false;
                shouldRetry = false;
                host = this.getUploadHost();
                try {
                    response = action.uploadAction(host);
                    if (response == null || response.needRetry()) {
                        shouldRetry = true;
                    }
                    if (response == null || response.needSwitchServer()) {
                        shouldSwitchHost = true;
                    }
                }
                catch (QiniuException e) {
                    if (e.isUnrecoverable() || e.response != null && !e.response.needRetry()) {
                        throw e;
                    }
                    shouldRetry = true;
                    if (e.isUnrecoverable() || e.response != null && !e.response.needSwitchServer()) break block7;
                    shouldSwitchHost = true;
                }
            }
            if (!shouldRetry) break;
            if (++retryCount >= this.config.retryMax) {
                throw QiniuException.unrecoverable("failed after retry times");
            }
            if (!shouldSwitchHost) continue;
            this.changeHost(host);
        }
        return response;
    }

    static interface UploadAction {
        public Response uploadAction(String var1) throws QiniuException;
    }
}

