/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.copy.product;

import com.qiwenshare.ufop.exception.operation.CopyException;
import com.qiwenshare.ufop.operation.copy.Copier;
import com.qiwenshare.ufop.operation.copy.domain.CopyFile;
import com.qiwenshare.ufop.util.UFOPUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalStorageCopier
extends Copier {
    private static final Logger log = LoggerFactory.getLogger(LocalStorageCopier.class);

    @Override
    public String copy(InputStream inputStream, CopyFile copyFile) {
        String uuid = UUID.randomUUID().toString();
        String fileUrl = UFOPUtils.getUploadFileUrl(uuid, copyFile.getExtendName());
        File saveFile = new File(UFOPUtils.getStaticPath() + fileUrl);
        try {
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)saveFile);
        }
        catch (IOException e) {
            throw new CopyException("\u521b\u5efa\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return fileUrl;
    }
}

