/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.delete.product;

import com.qiwenshare.ufop.config.MinioConfig;
import com.qiwenshare.ufop.exception.operation.DeleteException;
import com.qiwenshare.ufop.operation.delete.Deleter;
import com.qiwenshare.ufop.operation.delete.domain.DeleteFile;
import io.minio.MinioClient;
import io.minio.RemoveObjectArgs;
import io.minio.errors.MinioException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioDeleter
extends Deleter {
    private static final Logger log = LoggerFactory.getLogger(MinioDeleter.class);
    private MinioConfig minioConfig;

    public MinioDeleter() {
    }

    public MinioDeleter(MinioConfig minioConfig) {
        this.minioConfig = minioConfig;
    }

    @Override
    public void delete(DeleteFile deleteFile) {
        try {
            MinioClient minioClient = MinioClient.builder().endpoint(this.minioConfig.getEndpoint()).credentials(this.minioConfig.getAccessKey(), this.minioConfig.getSecretKey()).build();
            minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.minioConfig.getBucketName())).object(deleteFile.getFileUrl())).build());
            log.info("successfully removed mybucket/myobject");
        }
        catch (MinioException e) {
            log.error("Error: " + (Object)((Object)e));
            throw new DeleteException("Minio\u5220\u9664\u6587\u4ef6\u5931\u8d25", e);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new DeleteException("Minio\u5220\u9664\u6587\u4ef6\u5931\u8d25", e);
        }
        this.deleteCacheFile(deleteFile);
    }
}

