/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.preview.product;

import com.qiwenshare.ufop.domain.ThumbImage;
import com.qiwenshare.ufop.exception.operation.PreviewException;
import com.qiwenshare.ufop.operation.preview.Previewer;
import com.qiwenshare.ufop.operation.preview.domain.PreviewFile;
import com.qiwenshare.ufop.util.UFOPUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalStoragePreviewer
extends Previewer {
    private static final Logger log = LoggerFactory.getLogger(LocalStoragePreviewer.class);

    public LocalStoragePreviewer() {
    }

    public LocalStoragePreviewer(ThumbImage thumbImage) {
        this.setThumbImage(thumbImage);
    }

    /*
     * Loose catch block
     */
    @Override
    protected InputStream getInputStream(PreviewFile previewFile) {
        File file = UFOPUtils.getLocalSaveFile(previewFile.getFileUrl());
        if (!file.exists()) {
            throw new PreviewException("[UFOP] Failed to get the file stream because the file path does not exist! The file path is: " + file.getAbsolutePath());
        }
        FileInputStream inputStream = null;
        byte[] bytes = new byte[]{};
        try {
            inputStream = new FileInputStream(file);
            bytes = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return new ByteArrayInputStream(bytes);
    }
}

