/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.read.product;

import com.aliyun.oss.OSS;
import com.aliyun.oss.model.OSSObject;
import com.qiwenshare.ufop.config.AliyunConfig;
import com.qiwenshare.ufop.exception.operation.ReadException;
import com.qiwenshare.ufop.operation.read.Reader;
import com.qiwenshare.ufop.operation.read.domain.ReadFile;
import com.qiwenshare.ufop.util.AliyunUtils;
import com.qiwenshare.ufop.util.ReadFileUtils;
import com.qiwenshare.ufop.util.UFOPUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;

public class AliyunOSSReader
extends Reader {
    private AliyunConfig aliyunConfig;

    public AliyunOSSReader() {
    }

    public AliyunOSSReader(AliyunConfig aliyunConfig) {
        this.aliyunConfig = aliyunConfig;
    }

    @Override
    public String read(ReadFile readFile) {
        String fileUrl = readFile.getFileUrl();
        String fileType = FilenameUtils.getExtension((String)fileUrl);
        OSS ossClient = AliyunUtils.getOSSClient(this.aliyunConfig);
        OSSObject ossObject = ossClient.getObject(this.aliyunConfig.getOss().getBucketName(), UFOPUtils.getAliyunObjectNameByFileUrl(fileUrl));
        InputStream inputStream = ossObject.getObjectContent();
        try {
            String string = ReadFileUtils.getContentByInputStream(fileType, inputStream);
            return string;
        }
        catch (IOException e) {
            throw new ReadException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25", e);
        }
        finally {
            ossClient.shutdown();
        }
    }

    public InputStream getInputStream(String fileUrl) {
        OSS ossClient = AliyunUtils.getOSSClient(this.aliyunConfig);
        OSSObject ossObject = ossClient.getObject(this.aliyunConfig.getOss().getBucketName(), UFOPUtils.getAliyunObjectNameByFileUrl(fileUrl));
        return ossObject.getObjectContent();
    }
}

