/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.operation.upload;

import com.qiwenshare.ufop.exception.operation.UploadException;
import com.qiwenshare.ufop.operation.upload.domain.UploadFile;
import com.qiwenshare.ufop.operation.upload.domain.UploadFileResult;
import com.qiwenshare.ufop.operation.upload.request.QiwenMultipartFile;
import com.qiwenshare.ufop.util.RedisUtil;
import com.qiwenshare.ufop.util.concurrent.locks.RedisLock;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

@Component
public abstract class Uploader {
    private static final Logger log = LoggerFactory.getLogger(Uploader.class);
    @Resource
    RedisLock redisLock;
    @Resource
    RedisUtil redisUtil;

    public List<UploadFileResult> upload(HttpServletRequest httpServletRequest) {
        UploadFile uploadFile = new UploadFile();
        uploadFile.setChunkNumber(1);
        uploadFile.setChunkSize(0L);
        uploadFile.setTotalChunks(1);
        uploadFile.setIdentifier(UUID.randomUUID().toString());
        return this.upload(httpServletRequest, uploadFile);
    }

    public List<UploadFileResult> upload(HttpServletRequest httpServletRequest, UploadFile uploadFile) {
        ArrayList<UploadFileResult> uploadFileResultList = new ArrayList<UploadFileResult>();
        StandardMultipartHttpServletRequest request = (StandardMultipartHttpServletRequest)httpServletRequest;
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (!isMultipart) {
            throw new UploadException("\u672a\u5305\u542b\u6587\u4ef6\u4e0a\u4f20\u57df");
        }
        try {
            Iterator iter = request.getFileNames();
            while (iter.hasNext()) {
                List multipartFileList = request.getFiles((String)iter.next());
                for (MultipartFile multipartFile : multipartFileList) {
                    QiwenMultipartFile qiwenMultipartFile = new QiwenMultipartFile(multipartFile);
                    UploadFileResult uploadFileResult = this.doUploadFlow(qiwenMultipartFile, uploadFile);
                    uploadFileResultList.add(uploadFileResult);
                }
            }
        }
        catch (Exception e) {
            throw new UploadException(e);
        }
        return uploadFileResultList;
    }

    protected UploadFileResult doUploadFlow(QiwenMultipartFile qiwenMultipartFile, UploadFile uploadFile) {
        UploadFileResult uploadFileResult;
        try {
            this.rectifier(qiwenMultipartFile, uploadFile);
            uploadFileResult = this.organizationalResults(qiwenMultipartFile, uploadFile);
        }
        catch (Exception e) {
            throw new UploadException(e);
        }
        return uploadFileResult;
    }

    public abstract void cancelUpload(UploadFile var1);

    protected abstract void doUploadFileChunk(QiwenMultipartFile var1, UploadFile var2) throws IOException;

    protected abstract UploadFileResult organizationalResults(QiwenMultipartFile var1, UploadFile var2);

    private void rectifier(QiwenMultipartFile qiwenMultipartFile, UploadFile uploadFile) {
        String key = "QiwenUploader:Identifier:" + uploadFile.getIdentifier() + ":lock";
        String current_upload_chunk_number = "QiwenUploader:Identifier:" + uploadFile.getIdentifier() + ":current_upload_chunk_number";
        this.redisLock.lock(key);
        try {
            if (this.redisUtil.getObject(current_upload_chunk_number) == null) {
                this.redisUtil.set(current_upload_chunk_number, "1", 3600000L);
            }
            int currentUploadChunkNumber = Integer.parseInt(this.redisUtil.getObject(current_upload_chunk_number));
            if (uploadFile.getChunkNumber() != currentUploadChunkNumber) {
                this.redisLock.unlock(key);
                Thread.sleep(100L);
                while (this.redisLock.tryLock(key, 300L, TimeUnit.SECONDS)) {
                    currentUploadChunkNumber = Integer.parseInt(this.redisUtil.getObject(current_upload_chunk_number));
                    if (uploadFile.getChunkNumber() <= currentUploadChunkNumber) break;
                    if (Math.abs(currentUploadChunkNumber - uploadFile.getChunkNumber()) > 2) {
                        log.error("\u4f20\u5165\u7684\u5207\u7247\u6570\u636e\u5f02\u5e38\uff0c\u5f53\u524d\u5e94\u4e0a\u4f20\u5207\u7247\u4e3a\u7b2c{}\u5757\uff0c\u4f20\u5165\u7684\u4e3a\u7b2c{}\u5757\u3002", (Object)currentUploadChunkNumber, (Object)uploadFile.getChunkNumber());
                        throw new UploadException("\u4f20\u5165\u7684\u5207\u7247\u6570\u636e\u5f02\u5e38");
                    }
                    this.redisLock.unlock(key);
                }
            }
            log.info("\u6587\u4ef6\u540d{},\u6b63\u5728\u4e0a\u4f20\u7b2c{}\u5757, \u5171{}\u5757>>>>>>>>>>", new Object[]{qiwenMultipartFile.getMultipartFile().getOriginalFilename(), uploadFile.getChunkNumber(), uploadFile.getTotalChunks()});
            if (uploadFile.getChunkNumber() == currentUploadChunkNumber) {
                this.doUploadFileChunk(qiwenMultipartFile, uploadFile);
                log.info("\u6587\u4ef6\u540d{},\u7b2c{}\u5757\u4e0a\u4f20\u6210\u529f", (Object)qiwenMultipartFile.getMultipartFile().getOriginalFilename(), (Object)uploadFile.getChunkNumber());
                this.redisUtil.getIncr("QiwenUploader:Identifier:" + uploadFile.getIdentifier() + ":current_upload_chunk_number");
            }
        }
        catch (Exception e) {
            log.error("\u7b2c{}\u5757\u4e0a\u4f20\u5931\u8d25\uff0c\u81ea\u52a8\u91cd\u8bd5", (Object)uploadFile.getChunkNumber());
            this.redisUtil.set("QiwenUploader:Identifier:" + uploadFile.getIdentifier() + ":current_upload_chunk_number", String.valueOf(uploadFile.getChunkNumber()), 3600000L);
            throw new UploadException("\u66f4\u65b0\u8fdc\u7a0b\u6587\u4ef6\u51fa\u9519", e);
        }
        finally {
            this.redisLock.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean checkUploadStatus(UploadFile param, File confFile) throws IOException {
        byte[] completeStatusList;
        RandomAccessFile confAccessFile = new RandomAccessFile(confFile, "rw");
        try {
            confAccessFile.setLength(param.getTotalChunks());
            confAccessFile.seek(param.getChunkNumber() - 1);
            confAccessFile.write(127);
        }
        finally {
            IOUtils.closeQuietly((Closeable)confAccessFile);
        }
        for (byte b : completeStatusList = FileUtils.readFileToByteArray((File)confFile)) {
            if (b == 127) continue;
            return false;
        }
        confFile.delete();
        return true;
    }

    public void writeByteDataToFile(byte[] fileData, File file, UploadFile uploadFile) {
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            FileChannel fileChannel = raf.getChannel();
            long position = (long)(uploadFile.getChunkNumber() - 1) * uploadFile.getChunkSize();
            fileChannel.position(position);
            fileChannel.write(ByteBuffer.wrap(fileData));
            fileChannel.force(true);
            fileChannel.close();
            raf.close();
        }
        catch (IOException e) {
            throw new UploadException(e);
        }
    }
}

