/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.util;

import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    @Resource
    StringRedisTemplate stringRedisTemplate;

    public void set(String key, String value) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    public String getObject(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    public void set(String key, String value, long time) {
        if (time > 0L) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, time, TimeUnit.SECONDS);
        } else {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
        }
    }

    public boolean hasKey(String key) {
        return this.stringRedisTemplate.hasKey((Object)key);
    }

    public void deleteKey(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    public Long getIncr(String key) {
        return this.stringRedisTemplate.opsForValue().increment((Object)key, 1L);
    }
}

