/*
 * Decompiled with CFR 0.152.
 */
package com.qiwenshare.ufop.util.concurrent.locks;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.stereotype.Component;

@Component
public class RedisLock {
    private static final Logger log = LoggerFactory.getLogger(RedisLock.class);
    private static final int DEFAULT_ACQUIRE_RESOLUTION_MILLIS = 100;
    private static final String UNLOCK_LUA = "if redis.call(\"get\",KEYS[1]) == ARGV[1] then     return redis.call(\"del\",KEYS[1]) else     return 0 end ";
    private static final long LOCK_EXPIRE_TIME = 300L;
    @Resource
    StringRedisTemplate stringRedisTemplate;
    private final ThreadLocal<Map<String, LockVO>> lockMap = new ThreadLocal();

    public void lock(String key) {
        try {
            this.acquireLock(key, 300L, -1L);
        }
        catch (Exception e) {
            throw new RuntimeException("acquire lock exception", e);
        }
    }

    public void unlock(String key) {
        try {
            this.release(key);
        }
        catch (Exception e) {
            throw new RuntimeException("release lock exception", e);
        }
    }

    public boolean tryLock(String key) {
        try {
            return this.acquireLock(key, 300L, -1L);
        }
        catch (Exception e) {
            throw new RuntimeException("acquire lock exception", e);
        }
    }

    public boolean tryLock(String key, long time, TimeUnit unit) {
        try {
            return this.acquireLock(key, 300L, unit.toSeconds(time));
        }
        catch (Exception e) {
            throw new RuntimeException("acquire lock exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireLock(String key, long expire, long waitTime) throws InterruptedException {
        boolean acquired = this.acquired(key);
        if (acquired) {
            return true;
        }
        long acquireTime = waitTime == -1L ? -1L : waitTime * 1000L + System.currentTimeMillis();
        String string = key.intern();
        synchronized (string) {
            String lockId = UUID.randomUUID().toString();
            do {
                long before = System.currentTimeMillis();
                boolean hasLock = this.tryLock(key, expire, lockId);
                if (hasLock) {
                    long after = System.currentTimeMillis();
                    Map<String, LockVO> map = this.lockMap.get();
                    if (map == null) {
                        map = new HashMap<String, LockVO>(2);
                        this.lockMap.set(map);
                    }
                    map.put(key, new LockVO(1, lockId, expire * 1000L + before, expire * 1000L + after));
                    log.debug("acquire lock {} {} ", (Object)key, (Object)1);
                    return true;
                }
                Thread.sleep(100L);
            } while (acquireTime == -1L || acquireTime > System.currentTimeMillis());
        }
        log.info("acquire lock {} fail\uff0cbecause timeout ", (Object)key);
        return false;
    }

    private void release(String key) {
        Map<String, LockVO> map = this.lockMap.get();
        if (map == null || map.size() == 0 || !map.containsKey(key)) {
            return;
        }
        LockVO vo = map.get(key);
        if (vo.afterExpireTime < System.currentTimeMillis()) {
            log.debug("release lock {}, because timeout ", (Object)key);
            map.remove(key);
            return;
        }
        int after = --vo.count;
        log.debug("release lock {} {} ", (Object)key, (Object)after);
        if (after > 0) {
            return;
        }
        map.remove(key);
        RedisCallback callback = connection -> (Boolean)connection.eval(UNLOCK_LUA.getBytes(StandardCharsets.UTF_8), ReturnType.BOOLEAN, 1, (byte[][])new byte[][]{key.getBytes(StandardCharsets.UTF_8), vo.lockId.getBytes(StandardCharsets.UTF_8)});
        this.stringRedisTemplate.execute(callback);
    }

    private boolean tryLock(String key, long expire, String lockId) {
        try {
            RedisCallback callback = connection -> connection.set(key.getBytes(StandardCharsets.UTF_8), lockId.getBytes(StandardCharsets.UTF_8), Expiration.seconds((long)expire), RedisStringCommands.SetOption.SET_IF_ABSENT);
            return (Boolean)this.stringRedisTemplate.execute(callback);
        }
        catch (Exception e) {
            log.error("redis lock error.", (Throwable)e);
            return false;
        }
    }

    private boolean acquired(String key) {
        Map<String, LockVO> map = this.lockMap.get();
        if (map == null || map.size() == 0 || !map.containsKey(key)) {
            return false;
        }
        LockVO vo = map.get(key);
        if (vo.beforeExpireTime < System.currentTimeMillis()) {
            log.debug("lock {} maybe release, because timeout ", (Object)key);
            return false;
        }
        int after = ++vo.count;
        log.debug("acquire lock {} {} ", (Object)key, (Object)after);
        return true;
    }

    private static class LockVO {
        private int count;
        private String lockId;
        private long beforeExpireTime;
        private long afterExpireTime;

        LockVO(int count, String lockId, long beforeExpireTime, long afterExpireTime) {
            this.count = count;
            this.lockId = lockId;
            this.beforeExpireTime = beforeExpireTime;
            this.afterExpireTime = afterExpireTime;
        }
    }
}

