/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.base.elasticsearch.builder;

import java.util.Collection;
import java.util.List;

public class ElasticSearchQuery {
    private List<QueryBuilder> filter;
    private List<SortField> sort;
    private List<String> fields;
    private int pageSize;
    private int currentPage;

    public ElasticSearchQuery() {
    }

    public ElasticSearchQuery(Builder builder) {
        this.filter = builder.filter;
        this.sort = builder.sort;
        this.pageSize = builder.pageSize;
        this.currentPage = builder.currentPage;
        this.fields = builder.fields;
    }

    public List<QueryBuilder> getFilter() {
        return this.filter;
    }

    public List<SortField> getSort() {
        return this.sort;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public static enum SearchType {
        Default{

            public String toString() {
                return "Default";
            }
        }
        ,
        Like{

            public String toString() {
                return "Like";
            }
        }
        ,
        NotLike{

            public String toString() {
                return "NotLike";
            }
        }
        ,
        Range{

            public String toString() {
                return "Range";
            }
        }
        ,
        In{

            public String toString() {
                return "In";
            }
        }
        ,
        NotIn{

            public String toString() {
                return "NotIn";
            }
        }
        ,
        Exists{

            public String toString() {
                return "Exists";
            }
        }
        ,
        NotExists{

            public String toString() {
                return "NotExists";
            }
        }
        ,
        Nested{

            public String toString() {
                return "Nested";
            }
        }
        ,
        Union{

            public String toString() {
                return "Union";
            }
        }
        ,
        Script{

            public String toString() {
                return "Script";
            }
        };

    }

    public static enum OperationType {
        And{

            public String toString() {
                return "And";
            }
        }
        ,
        Or{

            public String toString() {
                return "Or";
            }
        };

    }

    public static enum SortOrder {
        ASC{

            public String toString() {
                return "asc";
            }
        }
        ,
        DESC{

            public String toString() {
                return "desc";
            }
        };

    }

    public static class SortField {
        private String field;
        private SortOrder order;

        public SortField() {
        }

        public SortField(String field, SortOrder order) {
            this.field = field;
            this.order = order;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public SortOrder getOrder() {
            return this.order;
        }

        public void setOrder(SortOrder order) {
            this.order = order;
        }
    }

    public static class Field {
        private String field;
        private Object value;
        private OperationType operationType;
        private SearchType searchType;
        private Object min;
        private Object max;
        private List<Field> groupField;
        private Collection<Object> values;

        public Field() {
        }

        public Field(String field, OperationType operationType, SearchType searchType) {
            this.field = field;
            this.operationType = operationType;
            this.searchType = searchType;
        }

        public Field(List<Field> groupField, OperationType operationType, SearchType searchType) {
            this.groupField = groupField;
            this.operationType = operationType;
            this.searchType = searchType;
        }

        public Field(String field, Object value, OperationType operationType, SearchType searchType) {
            this.field = field;
            this.value = value;
            this.operationType = operationType;
            this.searchType = searchType;
        }

        public Field(String field, Collection<Object> values, OperationType operationType, SearchType searchType) {
            this.field = field;
            this.operationType = operationType;
            this.searchType = searchType;
            this.values = values;
        }

        public Field(String field, OperationType operationType, SearchType searchType, Object min, Object max) {
            this.field = field;
            this.operationType = operationType;
            this.searchType = searchType;
            this.min = min;
            this.max = max;
        }

        public Field(String field, Object value, OperationType operationType, SearchType searchType, Object min, Object max, List<Field> groupField) {
            this.field = field;
            this.value = value;
            this.operationType = operationType;
            this.searchType = searchType;
            this.min = min;
            this.max = max;
            this.groupField = groupField;
        }

        public Field(String field, Object value, OperationType operationType, SearchType searchType, Object min, Object max, List<Field> groupField, Collection<Object> values) {
            this.field = field;
            this.value = value;
            this.operationType = operationType;
            this.searchType = searchType;
            this.min = min;
            this.max = max;
            this.groupField = groupField;
            this.values = values;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public OperationType getOperationType() {
            return this.operationType;
        }

        public void setOperationType(OperationType operationType) {
            this.operationType = operationType;
        }

        public SearchType getSearchType() {
            return this.searchType;
        }

        public void setSearchType(SearchType searchType) {
            this.searchType = searchType;
        }

        public Object getMin() {
            return this.min;
        }

        public void setMin(Object min) {
            this.min = min;
        }

        public Object getMax() {
            return this.max;
        }

        public void setMax(Object max) {
            this.max = max;
        }

        public List<Field> getGroupField() {
            return this.groupField;
        }

        public void setGroupField(List<Field> groupField) {
            this.groupField = groupField;
        }

        public Collection<Object> getValues() {
            return this.values;
        }

        public void setValues(Collection<Object> values) {
            this.values = values;
        }
    }

    public static class QueryBuilder {
        private List<Field> query;

        public List<Field> getQuery() {
            return this.query;
        }

        public void setQuery(List<Field> query) {
            this.query = query;
        }

        public QueryBuilder() {
        }

        public QueryBuilder(List<Field> query) {
            this.query = query;
        }
    }

    public static class Builder {
        private List<QueryBuilder> filter;
        private List<SortField> sort;
        private int pageSize;
        private int currentPage;
        private List<String> fields;

        public Builder filter(List<QueryBuilder> filter) {
            this.filter = filter;
            return this;
        }

        public Builder sort(List<SortField> sort) {
            this.sort = sort;
            return this;
        }

        public Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder currentPage(int currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public ElasticSearchQuery build() {
            return new ElasticSearchQuery(this);
        }
    }
}

