/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.mall.product;

import com.qqt.mall.common.dto.HistoryPriceDO;
import com.qqt.mall.common.dto.order.ConsignmentEntryDO;
import com.qqt.mall.common.dto.order.OrderDO;
import com.qqt.mall.common.dto.product.CategoryDO;
import com.qqt.mall.common.dto.product.InnerSaleStockParam;
import com.qqt.mall.common.dto.product.OrderStockDO;
import com.qqt.mall.common.dto.product.PriceDO;
import com.qqt.mall.common.dto.product.ProductSimpleSkuDO;
import com.qqt.mall.common.dto.product.ProductSkuBasicDO;
import com.qqt.mall.common.dto.product.ProductSkuDO;
import com.qqt.mall.common.dto.product.ProductSkuDetailDO;
import com.qqt.mall.common.dto.product.PromotionRuleDO;
import com.qqt.mall.common.dto.product.PurchaseClassDO;
import com.qqt.mall.common.dto.product.PurchaseGroupDO;
import com.qqt.mall.common.dto.product.StockDO;
import com.qqt.mall.common.dto.product.WarehouseDO;
import com.qqt.mall.common.dto.product.WarehouseDeliveryZoneDO;
import com.qqt.mall.common.dto.sync.BaseProductDO;
import com.qqt.mall.common.dto.sync.PurchaseProductSkuDO;
import com.qqt.mall.common.param.ConsignmentReceiveParam;
import com.qqt.mall.common.param.ReturnOrderStockParam;
import com.qqt.mall.product.config.UserFeignClientInterceptor;
import com.qqt.mall.product.service.dto.CommonRsqProductMessageDO;
import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.dto.SkuFreightPropertyDO;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="product", configuration={UserFeignClientInterceptor.class})
public interface ProductFeignService {
    public static final String OPTIONS_BASIC = "basic";
    public static final String OPTIONS_PRICE = "price";
    public static final String OPTIONS_STOCK = "stock";
    public static final String OPTIONS_CATEGORY = "category";
    public static final String OPTIONS_ATTR = "attribute";
    public static final String OPTIONS_PROMOTION = "promotion";

    @RequestMapping(value={"/api/mall-productsku/productSimpleSkuById/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<ResultDTO<ProductSimpleSkuDO>> getProductSimpleSkuById(@PathVariable(name="id") Long var1, @RequestParam(value="type") String var2);

    @GetMapping(value={"/api/mall-productsku/getMaterialNoBySkuId/{skuId}"})
    public ResultDTO<String> getMaterialBySkuId(@PathVariable(value="skuId") Long var1);

    @RequestMapping(value={"/api/productDetail/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<ResultDTO<ProductSkuDetailDO>> getProductByOptions(@PathVariable(name="id") Long var1, @RequestParam(value="options") String[] var2);

    @RequestMapping(value={"/api/mall-productsku/findDetailByProductSkuId/{skuId}"}, method={RequestMethod.GET})
    public ResponseEntity<ResultDTO<ProductSkuDetailDO>> findDetailByProductSkuId(@PathVariable(name="skuId") Long var1);

    @RequestMapping(value={"/api/product-skus/basic/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<ProductSkuBasicDO> getBasicProductSku(@PathVariable(name="id") Long var1);

    @RequestMapping(value={"/api/stock/reserve"}, method={RequestMethod.POST})
    public ResponseEntity<ResultDTO> reserveStock(@RequestBody OrderDO var1);

    @RequestMapping(value={"/api/stock/release"}, method={RequestMethod.POST})
    public ResponseEntity<ResultDTO> releaseStock(@RequestBody OrderDO var1);

    @RequestMapping(value={"/api/stock/reduce"}, method={RequestMethod.POST})
    public ResponseEntity<ResultDTO> reduceStock(@RequestBody OrderDO var1);

    @RequestMapping(value={"/api/purchaseclass/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<ResultDTO<PurchaseClassDO>> getPurchaseClass(@PathVariable(name="id") Long var1);

    @RequestMapping(value={"/api/skubudget/{productSkuId}"}, method={RequestMethod.GET})
    public ResponseEntity<Long> getBudgetClass(@PathVariable(name="productSkuId") Long var1);

    @RequestMapping(value={"/api/order-stocks/{orderCode}/{supplierCompanyId}/{storeId}"}, method={RequestMethod.GET})
    public ResponseEntity<List<OrderStockDO>> getOrderStock(@PathVariable(value="orderCode") String var1, @PathVariable(value="supplierCompanyId") Long var2, @PathVariable(value="storeId") Long var3);

    @RequestMapping(value={"/api/stock/releaseByList"}, method={RequestMethod.POST})
    public ResponseEntity<ResultDTO> releaseStockForList(@RequestBody List<OrderStockDO> var1);

    @RequestMapping(value={"/api/product/getProductByCode"}, method={RequestMethod.GET})
    public ResponseEntity<ProductSkuDetailDO> getProductByCode(@RequestParam(value="productCode") String var1, @RequestParam(value="catalogId") Long var2, @RequestParam(value="companyId") Long var3);

    @RequestMapping(value={"/api/stock/reduceByList"}, method={RequestMethod.POST})
    public ResponseEntity<ResultDTO> reduceStockByList(@RequestBody List<OrderStockDO> var1);

    @RequestMapping(value={"/api/stock/reduceByOrderStockIds"}, method={RequestMethod.POST})
    public ResponseEntity<ResultDTO> reduceByOrderStockIds(@RequestBody List<Long> var1);

    @RequestMapping(value={"/api/purchaseclass/getPurchaseClassesByUserGroupIds"}, method={RequestMethod.POST})
    public ResponseEntity<List<PurchaseClassDO>> getPurchaseClassesByUserGroupIds(@RequestParam(value="userGroupIds") List<Long> var1);

    @RequestMapping(value={"/api/order-stocks/getOrderStockDOList"}, method={RequestMethod.POST})
    public ResponseEntity<List<OrderStockDO>> getOrderStockDOList(@RequestBody OrderDO var1);

    @RequestMapping(value={"/api/warehouses/byCode/{code}"}, method={RequestMethod.GET})
    public ResponseEntity<List<WarehouseDO>> getAllWarehousesByCode(@PathVariable(value="code") String var1);

    @GetMapping(value={"/api/warehouses/{id}"})
    public ResponseEntity<WarehouseDO> getWarehouse(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/api/warehouses/getByIds"})
    public ResponseEntity<List<WarehouseDO>> getWarehouses(@RequestParam(value="ids") List<Long> var1);

    @PostMapping(value={"/api/creatWsmStockReceive"})
    public ResponseEntity creatWsmStockReceive(@RequestBody ConsignmentReceiveParam var1);

    @RequestMapping(value={"/api/price/updateJdProductPrice"}, method={RequestMethod.POST})
    public ResponseEntity<ResultDTO> updateJdProductPrice(@RequestBody List<PriceDO> var1);

    @RequestMapping(value={"/api/order-stocks/{orderCode}/{orderEntryCode}"}, method={RequestMethod.GET})
    public ResponseEntity<OrderStockDO> getOneOrderStock(@PathVariable(value="orderCode") String var1, @PathVariable(value="orderEntryCode") String var2);

    @RequestMapping(value={"/api/price/updateSnProductPrice"}, method={RequestMethod.POST})
    public ResponseEntity<ResultDTO> updateSNProductPrice(@RequestBody List<PriceDO> var1);

    @RequestMapping(value={"/api/price/updateZkhProductPrice"}, method={RequestMethod.POST})
    public ResponseEntity<ResultDTO> updateZkhProductPrice(@RequestBody List<PriceDO> var1);

    @RequestMapping(value={"/api/mall-productsku/getProductSkuDO"}, method={RequestMethod.GET})
    public ResponseEntity<ProductSkuDO> getProductSkuDOByCodeAndCompanyId(@RequestParam(value="code") String var1, @RequestParam(value="companyId") Long var2);

    @GetMapping(value={"/api/product-skus/code/{code}"})
    public ResponseEntity<ProductSkuDO> getProductSkuByCode(@PathVariable(value="code") String var1);

    @GetMapping(value={"/api/warehouses/byCompanyId/{companyId}"})
    public List<WarehouseDO> getwarehousesByCompanyId(@PathVariable(value="companyId") Long var1);

    @GetMapping(value={"/api/get-warehouse-delivery-zones"})
    public List<WarehouseDeliveryZoneDO> getAllWarehouseDeliveryZone();

    @GetMapping(value={"/api/mall-productsku/getComparePriceList/{skuId}"})
    public ResponseEntity<List<ProductSimpleSkuDO>> getComparePriceList(@PathVariable(name="skuId") Long var1);

    @RequestMapping(value={"/api/purchase-groups/findGroupByClassId"}, method={RequestMethod.GET})
    public ResponseEntity<List<PurchaseGroupDO>> findGroupByClassId(@RequestParam(value="id") Long var1);

    @RequestMapping(value={"/api/purchaseclass/getPurchaseClassesByOrgGroupIds"}, method={RequestMethod.POST})
    public ResponseEntity<List<Long>> getPurchaseClassesByOrgGroupIds(@RequestParam(value="userGroupIds") List<String> var1);

    @GetMapping(value={"/api/mall-productsku/getProductSkus"})
    public ResponseEntity<List<ProductSimpleSkuDO>> getProductSkus(@RequestParam(value="productSkuIds") List<Long> var1);

    @RequestMapping(value={"/api/price/updateLwxlProductPrice"}, method={RequestMethod.POST})
    public ResponseEntity<ResultDTO> updateLwxlProductPrice(List<PriceDO> var1);

    @RequestMapping(value={"/api/getSimpleProduct/{id}"}, method={RequestMethod.GET})
    public ResultDTO<ProductSkuDO> getSimpleProduct(@PathVariable(name="id") Long var1);

    @RequestMapping(value={"/api/mall-productsku/getImgsBySkuCode"}, method={RequestMethod.GET})
    public ResultDTO<List<String>> getImgsBySkuCode(@RequestParam(value="productCode") String var1);

    @RequestMapping(value={"/api/price/updateXYProductPrice"}, method={RequestMethod.POST})
    public ResponseEntity<ResultDTO> updateXYProductPrice(List<PriceDO> var1);

    @RequestMapping(value={"/api/mall-productsku/productSimpleSkuByIdAndWarehouse/{id}/{warehouseId}"}, method={RequestMethod.GET})
    public ResponseEntity<ResultDTO<ProductSimpleSkuDO>> getProductSimpleSkuByIdAndWarehouseAndBatch(@PathVariable(name="id") Long var1, @RequestParam(value="type") String var2, @PathVariable(name="warehouseId") Long var3, @RequestParam(value="batchNo") String var4);

    @RequestMapping(value={"/api/stocks/getStockById/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<StockDO> getStockById(@PathVariable(name="id") Long var1);

    @RequestMapping(value={"/api/stocks/getInnerSaleStock"}, method={RequestMethod.POST})
    public ResultDTO<StockDO> getInnerSaleStock(@RequestBody InnerSaleStockParam var1);

    @GetMapping(value={"/api/simpleWarehouses/{id}"})
    public ResultDTO<WarehouseDO> getSimpleWarehouses(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/api/promotionrules/{companyId}/{customerCompanyId}"})
    public ResultDTO<List<PromotionRuleDO>> getEffectiveStorePromotionRulesByCompanyId(@PathVariable(value="companyId") Long var1, @PathVariable(value="customerCompanyId") Long var2);

    @RequestMapping(value={"/api/stocks/getInnerSaleStockList"}, method={RequestMethod.POST})
    public ResultDTO<List<StockDO>> getInnerSaleStockList(@RequestBody List<InnerSaleStockParam> var1);

    @RequestMapping(value={"/api/price/updateThirdProductPrice"}, method={RequestMethod.POST})
    public ResponseEntity<ResultDTO> updateThirdProductPrice(@RequestBody List<PriceDO> var1, @RequestParam(value="thirdPlatformCode") String var2);

    @GetMapping(value={"/api/getAllChild/{id}"})
    public ResultDTO<List<Long>> getAllChild(@PathVariable(value="id") Long var1);

    @PostMapping(value={"/api/mall-productsku/getSkuFreightProperty"})
    public ResponseEntity<List<SkuFreightPropertyDO>> getSkuFreightProperty(@RequestBody List<Long> var1);

    @RequestMapping(value={"/api/purchaseclass/getPurchaseClassMap"}, method={RequestMethod.POST})
    public ResultDTO<Map<Long, PurchaseClassDO>> getPurchaseClassMap(@RequestBody List<Long> var1);

    @RequestMapping(value={"/api/stock/reserveNewStock"}, method={RequestMethod.POST})
    public ResultDTO reserveNewStock(@RequestParam(value="orderCode") String var1, @RequestParam(value="orderEntryCode") String var2, @RequestParam(value="quantity") Long var3, @RequestParam(value="productCode") String var4, @RequestParam(value="supplierId") Long var5);

    @PostMapping(value={"/api/stocks/returnReservedStock/{productCode}"})
    public ResponseEntity<ResultDTO> returnReservedStock(@PathVariable(value="productCode") String var1, @RequestParam(value="quantity") Long var2);

    @PostMapping(value={"/api/stocks/returnAndUpdateStock"})
    public ResponseEntity<Void> returnAndUpdateStock(@RequestBody ReturnOrderStockParam var1);

    @PostMapping(value={"/api/stocks/returnAndUpdateStockList"})
    public ResponseEntity<Void> returnAndUpdateStockList(@RequestBody List<ReturnOrderStockParam> var1);

    @RequestMapping(value={"/api/order-stocks/getOrderStockDOListForDelivery"}, method={RequestMethod.POST})
    public ResultDTO<List<OrderStockDO>> getOrderStockDOListForDelivery(@RequestBody List<OrderStockDO> var1);

    @RequestMapping(value={"/api/product-pools/msg/handleProductMsg"}, method={RequestMethod.POST})
    public ResponseEntity<ResultDTO> handleProductMsg(@RequestBody CommonRsqProductMessageDO var1);

    @RequestMapping(value={"/api/wms-stocks/getWmsStockQtyByWarehouse/{warehouseId}/{skuCode}"}, method={RequestMethod.GET})
    public ResponseEntity<Long> getWmsStockQtyByWarehouse(@PathVariable(name="warehouseId") Long var1, @PathVariable(name="skuCode") String var2);

    @RequestMapping(value={"/api/wms-stocks/getOrderByWmsStock/{warehouseId}/{skuCode}"}, method={RequestMethod.GET})
    public ResponseEntity<Set<Long>> getOrderByWmsStock(@PathVariable(name="warehouseId") Long var1, @PathVariable(name="skuCode") String var2);

    @GetMapping(value={"/enquiry/demand/detail/countWaitProcess"})
    public ResultDTO<Long> countWaitProcess(@RequestParam(value="groupIds") List<Long> var1);

    @GetMapping(value={"/enquiry/saleEnquiryHead/countWaitEnquiry"})
    public ResultDTO<Integer> countWaitProcessEnquiry();

    @RequestMapping(value={"/api/history-price/insertByOrder"}, method={RequestMethod.POST})
    public ResponseEntity insertByOrder(@RequestBody List<HistoryPriceDO> var1);

    @RequestMapping(value={"/api/history-price/insertByContract"}, method={RequestMethod.POST})
    public ResponseEntity insertByContract(@RequestBody List<HistoryPriceDO> var1);

    @GetMapping(value={"/api/get-productSku-purchase/{companyId}/{productCode}"})
    public ResultDTO<ProductSkuDO> getProductSkuDOByCodeAndPurChaseCompanyId(@PathVariable(value="productCode") String var1, @PathVariable(value="companyId") Long var2);

    @GetMapping(value={"/api/warehouses/{companyId}/{code}"})
    public ResultDTO<Long> getWarehouseByCodeAndCompanyId(@PathVariable(value="code") String var1, @PathVariable(value="companyId") Long var2);

    @RequestMapping(value={"/getContracSkuPrice/{skuId}/{companyId}/{type}"}, method={RequestMethod.GET})
    public ResponseEntity<PriceDO> getContracSkuPrice(@PathVariable(value="skuId") Long var1, @PathVariable(value="companyId") Long var2, @PathVariable(value="type") String var3);

    @RequestMapping(value={"/api/asset-records/createByConsignmentEntryList"}, method={RequestMethod.POST})
    public ResultDTO createByConsignmentEntryList(@RequestBody List<ConsignmentEntryDO> var1);

    @RequestMapping(value={"/api/getOne/{id}"}, method={RequestMethod.GET})
    public Map<String, String> getOne(@PathVariable(value="id") Long var1);

    @RequestMapping(value={"/enquiry/demand/detail/updateEnquiryAndPool"}, method={RequestMethod.GET})
    public void updateEnquiryAndPool(@RequestParam(value="enquiryNumber") String var1, @RequestParam(value="baseProductId") Long var2, @RequestParam(value="productId") Long var3, @RequestParam(value="productCode") String var4, @RequestParam(value="productName") String var5);

    @GetMapping(value={"/api/categoriesDO/{id}"})
    public ResultDTO<CategoryDO> getCategoryDO(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/api/category/getPurchaserCategories/{productSkuId}"})
    public ResultDTO<List<Long>> getPurchaserCategories(@PathVariable(value="productSkuId") Long var1);

    @GetMapping(value={"/api/base-products/getBaseProductByMatrlNoAndCompanyId/{matrlNo}/{companyId}"})
    public ResultDTO<BaseProductDO> getBaseProductByMatrlNoAndCompanyId(@PathVariable(value="matrlNo") String var1, @PathVariable(value="companyId") Long var2);

    @GetMapping(value={"/api/purchase-product-skus/getPurchaseProductSkuBySkuIdAndCompanyId/{productSkuId}/{companyId}"})
    public ResultDTO<PurchaseProductSkuDO> getPurchaseProductSkuBySkuIdAndCompanyId(@PathVariable(value="productSkuId") Long var1, @PathVariable(value="companyId") Long var2);

    @GetMapping(value={"/api/categories/getCategoryById/{id}"})
    public ResultDTO<CategoryDO> getCategoryById(@PathVariable(value="id") Long var1);
}

