/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.mall.product.config;

import com.qqt.mall.common.security.SecurityUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserFeignClientInterceptor
implements RequestInterceptor {
    private final Logger log = LoggerFactory.getLogger(UserFeignClientInterceptor.class);
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER = "Bearer";

    public void apply(RequestTemplate template) {
        SecurityUtils.getCurrentUserJWT().ifPresent(s -> template.header(AUTHORIZATION_HEADER, new String[]{String.format("%s %s", BEARER, s)}));
    }
}

