/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.mall.common.service;

import com.qqt.platform.common.feign.AdminFeignService;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SystemConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemConfigService.class);
    public static final String COPY_ADDRESS = "COPY_ADDRESS_";
    public static final String THIRD_COMPANYIDS = "THIRD_COMPANYIDS_";
    public static final String PLACE_ORDER_STRATEGY = "PLACE_ORDER_STRATEGY_";
    public static final String CREATE_CART_STRATEGY = "CREATE_CART_STRATEGY_";
    public static final String PRODUCT_STOCK_STRATEGY = "PRODUCT_STOCK_STRATEGY_";
    public static final String DELIVERYCOST_CALCULATION_STRATEGY = "DELIVERYCOST_CALCULATION_STRATEGY_";
    public static final String AUTO_APPROVAL = "AUTO_APPROVAL_";
    @Autowired
    private AdminFeignService adminFeignService;

    public Boolean isCopyAddress(Long siteId) {
        ResponseEntity copyAddressOpt = this.adminFeignService.getSysValue(COPY_ADDRESS + siteId);
        if (copyAddressOpt != null && copyAddressOpt.getBody() != null) {
            try {
                return Boolean.parseBoolean((String)copyAddressOpt.getBody());
            }
            catch (Exception e) {
                LOGGER.error("copyAddress is error for site:" + siteId, (Throwable)e);
            }
        }
        return Boolean.FALSE;
    }

    public String getThirdCompanyIds(Long siteId) {
        ResponseEntity optional = this.adminFeignService.getSysValue(THIRD_COMPANYIDS + siteId);
        if (optional != null && optional.getBody() != null) {
            try {
                return (String)optional.getBody();
            }
            catch (Exception e) {
                LOGGER.error("copyAddress is error for site:" + siteId, (Throwable)e);
            }
        }
        return "";
    }

    public String getPlaceOrderBeanIdForSiteAndSupplyCompanyId(Long siteId, Long supplierCompanyId) {
        ResponseEntity responseEntity;
        String thirdCompanyIds = this.getThirdCompanyIds(siteId);
        boolean isThirdCompany = Stream.of(thirdCompanyIds.split(",")).filter(companyId -> companyId.equals(supplierCompanyId)).findAny().isPresent();
        String placeOrderStrategy = "placeOrderStrategyImpl";
        if (isThirdCompany && (responseEntity = this.adminFeignService.getSysValue(PLACE_ORDER_STRATEGY + siteId + "_" + supplierCompanyId)) != null && responseEntity.getBody() != null && !StringUtils.isEmpty((Object)responseEntity.getBody())) {
            placeOrderStrategy = (String)responseEntity.getBody();
        }
        return placeOrderStrategy;
    }

    public String getCreateCartStrategy(Long siteId, Long storeId) {
        ResponseEntity optional = this.adminFeignService.getSysValue(CREATE_CART_STRATEGY + siteId + "_" + storeId);
        if (optional != null && optional.getBody() != null) {
            try {
                return (String)optional.getBody();
            }
            catch (Exception e) {
                LOGGER.error("getCreateCartStrategy is error for site:" + siteId, (Throwable)e);
            }
        }
        return "createCartStrategyForSupplierImpl";
    }

    public Long getCompanyIdByCode(String code) {
        ResponseEntity result = this.adminFeignService.getSysValue(code);
        if (result != null && result.getBody() != null) {
            try {
                return Long.valueOf((String)result.getBody());
            }
            catch (Exception e) {
                LOGGER.error("\u6839\u636ejd\u516c\u53f8code\u83b7\u53d6\u516c\u53f8id\u5931\u8d25,code : " + code, (Throwable)e);
            }
        }
        return null;
    }

    public Boolean getAutoApproval(Long companyId, Long categoryId) {
        ResponseEntity resultByCompanyIdAndCategoryId = this.adminFeignService.getSysValue(AUTO_APPROVAL + companyId + "_" + categoryId);
        if (resultByCompanyIdAndCategoryId != null && resultByCompanyIdAndCategoryId.getBody() != null) {
            try {
                return Boolean.parseBoolean((String)resultByCompanyIdAndCategoryId.getBody());
            }
            catch (Exception e) {
                LOGGER.error("AutoApproval is error for companyId:" + companyId + " and categoryId:" + categoryId, (Throwable)e);
            }
        } else {
            ResponseEntity resultByCompanyId = this.adminFeignService.getSysValue(AUTO_APPROVAL + companyId);
            if (resultByCompanyId != null && resultByCompanyId.getBody() != null) {
                try {
                    return Boolean.parseBoolean((String)resultByCompanyId.getBody());
                }
                catch (Exception e) {
                    LOGGER.error("AutoApproval is error for companyId:" + companyId, (Throwable)e);
                }
            }
        }
        return Boolean.FALSE;
    }

    public String getSupplierProductStockStrategy(Long siteId, Long supplierId) {
        ResponseEntity optional = this.adminFeignService.getSysValue(PRODUCT_STOCK_STRATEGY + siteId + "_" + supplierId);
        if (optional != null && optional.getBody() != null) {
            try {
                return (String)optional.getBody();
            }
            catch (Exception e) {
                LOGGER.error("getSupplierProductStockStrategy is error for site:" + siteId, (Throwable)e);
            }
        }
        return "supplierProductStockStrategyImpl";
    }

    public String getDeliveryCostCalculationStrategy(Long siteId, Long supplierId) {
        ResponseEntity optional = this.adminFeignService.getSysValue(DELIVERYCOST_CALCULATION_STRATEGY + siteId + "_" + supplierId);
        if (optional != null && optional.getBody() != null) {
            try {
                return (String)optional.getBody();
            }
            catch (Exception e) {
                LOGGER.error("getDeliveryCostCalculationStrategy is error for site:" + siteId, (Throwable)e);
            }
        }
        return "deliveryCostCalculationStrategyImpl";
    }
}

