/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.mall.common.sourcepool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qqt.mall.common.dto.ServiceDTO;
import com.qqt.mall.common.dto.product.PageDO;
import com.qqt.mall.common.service.SystemConfigService;
import com.qqt.mall.common.sourcepool.SourcePoolRoute;
import com.qqt.mall.common.util.HttpClientUtil;
import com.qqt.mall.common.util.JdkSignatureUtil;
import com.qqt.platform.common.dto.CompanyApnDO;
import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.exception.BaseAssert;
import com.qqt.platform.common.exception.BusinessException;
import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.service.I18NMsgService;
import com.qqt.platform.common.service.SessionService;
import com.qqt.platform.common.utils.ResultUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Component
@Aspect
public class SourcePoolRouteAspect {
    private final Logger log = LoggerFactory.getLogger(SourcePoolRouteAspect.class);
    @Autowired
    private SessionService sessionService;
    @Autowired
    private I18NMsgService i18NMsgService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private AdminFeignService adminFeignService;

    @Pointcut(value="@annotation(com.qqt.mall.common.sourcepool.SourcePoolRoute)")
    public void point() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Around(value="point()")
    public Object process(ProceedingJoinPoint pjp) throws Throwable {
        ResultDTO resultDTO;
        Map<String, Object> pathAndMethod;
        Object pathObj;
        Object[] args = pjp.getArgs();
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method signatureMethod = signature.getMethod();
        this.log.debug("\u63a5\u53e3\u5207\u6362\u8c03\u7528\u53c2\u6570\uff1a{}", (Object)(args == null ? "" : args[0].toString()));
        String code = this.systemConfigService.getSystemConfigValueByCode("SOURCEPOOL_SWITCH");
        if (!signatureMethod.isAnnotationPresent(SourcePoolRoute.class) || !StringUtils.isNotBlank((CharSequence)code) || !"1".equals(code)) return pjp.proceed(args);
        SourcePoolRoute sourcePoolRoute = signatureMethod.getAnnotation(SourcePoolRoute.class);
        String path = sourcePoolRoute.path();
        if (StringUtils.isBlank((CharSequence)path) && (pathObj = (pathAndMethod = this.getPathAndMethod(path, sourcePoolRoute, signature)).get("path")) == null) {
            throw new BusinessException("sourcePoolRoute.path.isNull", this.i18NMsgService.getMsg("sourcePoolRoute.path.isNull"));
        }
        String type = sourcePoolRoute.type();
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new BusinessException("sourcePoolRoute.type.isNull", this.i18NMsgService.getMsg("sourcePoolRoute.type.isNull"));
        }
        String currentCompanyCode = this.sessionService.getCurrentCompanyCode();
        if (StringUtils.isBlank((CharSequence)currentCompanyCode)) {
            throw new BusinessException("sourcePoolRoute.CompanyCode.isNull", this.i18NMsgService.getMsg("sourcePoolRoute.CompanyCode.isNull"));
        }
        ServiceDTO serviceDTO = new ServiceDTO();
        serviceDTO.setCompanyCode(currentCompanyCode);
        serviceDTO.setInterfaceName(type);
        serviceDTO.setMethod(signatureMethod.getName());
        if (args != null && args.length > 0) {
            String param = JSONObject.toJSONString((Object)args);
            serviceDTO.setParam(param);
        }
        BaseAssert.isTrue(((resultDTO = this.adminFeignService.getCompanyApnByTypeAndCode(type, currentCompanyCode)).isSuccess() && resultDTO.getData() != null && StringUtils.isNotBlank((CharSequence)((CompanyApnDO)resultDTO.getData()).getKey()) ? 1 : 0) != 0, (String)this.i18NMsgService.getMsg("sourcePoolRoute.PrivateKey.isNull"));
        String privateKey = ((CompanyApnDO)resultDTO.getData()).getKey();
        StringBuilder sb = new StringBuilder();
        sb.append("companyCode=" + serviceDTO.getCompanyCode()).append("&").append("interfaceName" + serviceDTO.getInterfaceName()).append("&").append("method=" + serviceDTO.getMethod()).append("&").append("param=" + serviceDTO.getParam());
        String sign = JdkSignatureUtil.executeSignature(privateKey, sb.toString());
        serviceDTO.setSign(sign);
        String basePath = this.systemConfigService.getSystemConfigValueByCode("SOURCEPOOL_BASE_PATH");
        BaseAssert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)basePath), (String)this.i18NMsgService.getMsg("sourcePoolRoute.basePath.isNull"));
        this.log.debug("\u8c03\u7528\u805a\u6e90\u6c60\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)serviceDTO));
        String result = HttpClientUtil.doPostJson(basePath, JSON.toJSONString((Object)serviceDTO), null);
        this.log.debug("\u8c03\u7528\u805a\u6e90\u6c60\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
        BaseAssert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)result), (String)this.i18NMsgService.getMsg("sourcePoolRoute.result.isNull"));
        ResultDTO dto = (ResultDTO)JSONObject.parseObject((String)result, ResultDTO.class);
        if (dto == null || !dto.isSuccess()) return ResponseEntity.ok();
        this.log.debug("\u8c03\u7528\u805a\u6e90\u6c60\u8fd4\u56de\u7ed3\u679cJSON\u4e32\uff1a{}", dto.getData());
        JSONObject object = JSONObject.parseObject((String)((String)dto.getData()));
        if (object == null) return ResponseEntity.ok();
        Object body = null;
        if (sourcePoolRoute.returnMainType() == Void.class) {
            return ResponseEntity.ok();
        }
        if (sourcePoolRoute.isList() && !sourcePoolRoute.secondIfResultDTO()) {
            body = JSONObject.parseArray((String)object.getJSONArray("body").toString(), sourcePoolRoute.returnMainType());
            return ResponseEntity.ok((Object)body);
        }
        if (sourcePoolRoute.isList() && sourcePoolRoute.secondIfResultDTO()) {
            JSONArray jsonArray = object.getJSONObject("body").getJSONArray("data");
            if (jsonArray == null || jsonArray.size() <= 0) return ResponseEntity.ok((Object)ResultUtil.success());
            body = JSONObject.parseArray((String)jsonArray.toString(), sourcePoolRoute.returnMainType());
            return ResponseEntity.ok((Object)ResultUtil.success((Object)body));
        }
        if (!sourcePoolRoute.isList() && sourcePoolRoute.secondIfResultDTO()) {
            JSONObject body1 = object.getJSONObject("body");
            if (body1 == null) {
                return ResponseEntity.ok((Object)ResultUtil.success());
            }
            Object data = body1.get((Object)"data");
            if (data == null) {
                Boolean success = body1.getBoolean("success");
                if (!success.booleanValue()) return ResponseEntity.ok((Object)ResultUtil.fail((int)500, null, (String)body1.getString("msg")));
                return ResponseEntity.ok((Object)ResultUtil.success());
            }
            if ("true".equals(data.toString()) || "false".equals(data.toString())) {
                body = JSONObject.parseObject((String)data.toString(), sourcePoolRoute.returnMainType());
                return ResponseEntity.ok((Object)ResultUtil.success((Object)body));
            }
            JSONObject jsonObject = object.getJSONObject("body").getJSONObject("data");
            if (sourcePoolRoute.returnMainType().equals(PageDO.class)) {
                PageDO page = (PageDO)JSONObject.parseObject((String)JSON.toJSONString((Object)jsonObject.get((Object)"data")), PageDO.class);
                return ResponseEntity.ok((Object)ResultUtil.success((Object)page));
            }
            if (jsonObject == null) return ResponseEntity.ok();
            body = JSONObject.parseObject((String)jsonObject.toString(), sourcePoolRoute.returnMainType());
            return ResponseEntity.ok((Object)ResultUtil.success((Object)body));
        }
        if (Boolean.class.equals(sourcePoolRoute.returnMainType())) {
            return ResponseEntity.ok((Object)object.getBoolean("body"));
        }
        body = JSONObject.parseObject((String)object.getJSONObject("body").toString(), sourcePoolRoute.returnMainType());
        return ResponseEntity.ok((Object)body);
    }

    private Map<String, Object> getPathAndMethod(String path, SourcePoolRoute sourcePoolRoute, MethodSignature signature) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        RequestMethod method = sourcePoolRoute.method();
        Method signatureMethod = signature.getMethod();
        if (signatureMethod.getAnnotation(RequestMapping.class) != null && signatureMethod.getAnnotation(RequestMapping.class).value() != null) {
            RequestMapping annotation = signatureMethod.getAnnotation(RequestMapping.class);
            path = annotation.value()[0];
            RequestMethod[] methods = annotation.method();
            if (methods != null && methods.length > 0) {
                method = methods[0];
            }
        } else if (signatureMethod.getAnnotation(GetMapping.class) != null && signatureMethod.getAnnotation(GetMapping.class).value() != null) {
            GetMapping annotation = signatureMethod.getAnnotation(GetMapping.class);
            path = annotation.value()[0];
            method = RequestMethod.GET;
        } else if (signatureMethod.getAnnotation(PostMapping.class) != null && signatureMethod.getAnnotation(PostMapping.class).value() != null) {
            PostMapping annotation = signatureMethod.getAnnotation(PostMapping.class);
            path = annotation.value()[0];
        }
        map.put("path", path);
        map.put("method", method);
        return map;
    }
}

