/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.mall.common.service;

import com.alibaba.fastjson.JSON;
import com.qqt.mall.common.service.FeignCacheService;
import com.qqt.platform.common.dto.AddressDO;
import com.qqt.platform.common.dto.DictionaryDO;
import com.qqt.platform.common.dto.InvoiceInfoDO;
import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.dto.UserDTO;
import com.qqt.platform.common.feign.AdminFeignService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jodd.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class FeignCacheServiceImpl
implements FeignCacheService {
    private final Long TIMEOUT_MINUTES = 60L;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private AdminFeignService adminFeignService;

    @Override
    public List<DictionaryDO> getDictionariesByType(String invoiceType) {
        if (invoiceType == null) {
            return null;
        }
        String key = "dictionariesByType:invoiceType:" + invoiceType;
        String json = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (StringUtil.isNotBlank((CharSequence)json)) {
            List list = JSON.parseArray((String)json, DictionaryDO.class);
            return list;
        }
        ResponseEntity dictionariesByType = this.adminFeignService.getDictionariesByType(invoiceType);
        if (dictionariesByType != null && dictionariesByType.hasBody()) {
            List list = (List)dictionariesByType.getBody();
            json = JSON.toJSONString((Object)list);
            this.redisTemplate.opsForValue().set((Object)key, (Object)json, this.TIMEOUT_MINUTES.longValue(), TimeUnit.MINUTES);
            return list;
        }
        return null;
    }

    @Override
    public String getSystemConfigValueByCode(String sysKey) {
        if (sysKey == null) {
            return null;
        }
        String key = "systemConfig:sysKey:" + sysKey;
        String json = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (StringUtil.isNotBlank((CharSequence)json)) {
            return json;
        }
        ResponseEntity sysValue = this.adminFeignService.getSysValue(sysKey);
        if (sysValue != null && sysValue.hasBody()) {
            json = (String)sysValue.getBody();
            this.redisTemplate.opsForValue().set((Object)key, (Object)json, this.TIMEOUT_MINUTES / 4L, TimeUnit.MINUTES);
            return json;
        }
        return null;
    }

    @Override
    public UserDTO getUserById(Long userId) {
        if (userId == null) {
            return new UserDTO();
        }
        String key = "UserDTO:id:" + userId;
        UserDTO userDTO = this.getResultDTOBody(key, UserDTO.class, () -> this.adminFeignService.getUserById(userId));
        return userDTO;
    }

    @Override
    public AddressDO getAddressDO(Long companyId, Long id) {
        if (id == null && companyId == null) {
            return null;
        }
        String key = "AddressDO:id:" + id + ":companyId:" + companyId;
        AddressDO addressDO = this.getResponseEntityBody(key, AddressDO.class, () -> this.adminFeignService.getAddressDO(companyId, id));
        return addressDO;
    }

    @Override
    public InvoiceInfoDO getInvoiceInfo(Long companyId, Long invoiceInfoId) {
        if (invoiceInfoId == null && companyId == null) {
            return null;
        }
        String key = "InvoiceInfoDO:id:" + invoiceInfoId + ":companyId:" + companyId;
        InvoiceInfoDO invoiceInfoDO = this.getResponseEntityBody(key, InvoiceInfoDO.class, () -> this.adminFeignService.getInvoiceInfo(companyId, invoiceInfoId));
        return invoiceInfoDO;
    }

    @Override
    public List<InvoiceInfoDO> getInvoiceInfoByCompanyId(Long companyId) {
        if (companyId == null) {
            return new ArrayList<InvoiceInfoDO>();
        }
        String key = "InvoiceInfoDO:companyId:" + companyId;
        List<InvoiceInfoDO> invoiceInfoDOList = this.getResponseEntityListBody(key, InvoiceInfoDO.class, () -> this.adminFeignService.getInvoiceInfoByCompanyId(companyId));
        return invoiceInfoDOList;
    }

    private <T> T getResponseEntityBody(String key, Class<T> clazz, CallBack<T> callBack) {
        String json = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (StringUtil.isNotBlank((CharSequence)json)) {
            Object t = JSON.parseObject((String)json, clazz);
            return (T)t;
        }
        ResponseEntity<T> entity = callBack.doSomething();
        if (entity != null && entity.hasBody()) {
            Object value = entity.getBody();
            json = JSON.toJSONString((Object)value);
            this.redisTemplate.opsForValue().set((Object)key, (Object)json, this.TIMEOUT_MINUTES.longValue(), TimeUnit.MINUTES);
            return (T)value;
        }
        return null;
    }

    private <T> List<T> getResponseEntityListBody(String key, Class<T> clazz, CallBackList<T> callBack) {
        String json = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (StringUtil.isNotBlank((CharSequence)json) && StringUtil.isNotBlank((CharSequence)json)) {
            List tList = JSON.parseArray((String)json, clazz);
            return tList;
        }
        ResponseEntity<List<T>> entity = callBack.doSomething();
        if (entity != null && entity.hasBody()) {
            List value = (List)entity.getBody();
            json = JSON.toJSONString((Object)value);
            this.redisTemplate.opsForValue().set((Object)key, (Object)json, this.TIMEOUT_MINUTES.longValue(), TimeUnit.MINUTES);
            return value;
        }
        return null;
    }

    private <T> T getResultDTOBody(String key, Class<T> clazz, CallBack<ResultDTO<T>> callBack) {
        String json = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (StringUtil.isNotBlank((CharSequence)json)) {
            Object t = JSON.parseObject((String)json, clazz);
            return (T)t;
        }
        ResponseEntity<ResultDTO<T>> entity = callBack.doSomething();
        if (entity != null && entity.hasBody()) {
            ResultDTO resultDTO = (ResultDTO)entity.getBody();
            Object body = resultDTO.getData();
            if (body != null) {
                json = JSON.toJSONString((Object)body);
                this.redisTemplate.opsForValue().set((Object)key, (Object)json, this.TIMEOUT_MINUTES.longValue(), TimeUnit.MINUTES);
            }
            return (T)body;
        }
        return null;
    }

    private static interface CallBackList<T> {
        public ResponseEntity<List<T>> doSomething();
    }

    private static interface CallBack<T> {
        public ResponseEntity<T> doSomething();
    }
}

