/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.mall.common.service;

import com.qqt.mall.common.service.PoolService;
import com.qqt.mall.common.service.SystemConfigService;
import com.qqt.platform.common.dto.CompanyApnDO;
import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.service.SessionService;
import com.qqt.platform.common.utils.ThreadLocalUtil;
import com.qqt.pool.api.DefaultPoolClient;
import com.qqt.pool.api.PoolClient;
import com.qqt.pool.api.request.PoolRequestBean;
import com.qqt.pool.api.response.PoolRespBean;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class PoolServiceImpl
implements PoolService {
    private final Logger log = LoggerFactory.getLogger(PoolServiceImpl.class);
    @Resource
    private AdminFeignService adminFeignService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private SessionService sessionService;
    @Autowired
    private RedisTemplate redisTemplate;
    private PoolClient poolClient = new DefaultPoolClient();
    private static final String APN_KEY_COMPANYID = "APN_KEY_COMPANYCODE_";
    private static final String POOL_BASE_URL = "POOL_BASE_URL";

    @Override
    public <T extends PoolRespBean> T service(PoolRequestBean poolRequestBean) {
        PoolRespBean execute = null;
        try {
            execute = this.poolClient.execute(this.getPoolBaseUrl(), poolRequestBean, this.getApnKeyByCompanyCode(this.sessionService.getCurrentCompanyCode()));
        }
        catch (IOException e) {
            e.printStackTrace();
            this.log.info("\u8c03\u7528\u5931\u8d25:{}", (Object)e.getMessage());
        }
        return (T)execute;
    }

    private String getPoolBaseUrl() {
        Object obj = this.redisTemplate.opsForValue().get((Object)POOL_BASE_URL);
        String poolBaseUrl = null;
        if (Objects.isNull(obj)) {
            poolBaseUrl = this.systemConfigService.getPoolBaseUrl();
            this.redisTemplate.opsForValue().set((Object)POOL_BASE_URL, (Object)poolBaseUrl, 30L, TimeUnit.MINUTES);
        } else {
            poolBaseUrl = (String)obj;
        }
        return "http://106.52.242.179:9001/services/admin/pool/server";
    }

    private String getApnKeyByCompanyCode(String companyCode) {
        Object code = ThreadLocalUtil.get((String)"companyCode");
        if (Objects.nonNull(code)) {
            companyCode = (String)code;
        }
        Object obj = this.redisTemplate.opsForValue().get((Object)(APN_KEY_COMPANYID + companyCode));
        String key = null;
        if (Objects.isNull(obj)) {
            ResultDTO resultDTO = this.adminFeignService.getCompanyApnByCode(companyCode);
            key = ((CompanyApnDO)resultDTO.getData()).getKey();
            this.redisTemplate.opsForValue().set((Object)(APN_KEY_COMPANYID + companyCode), (Object)key, 15L, TimeUnit.MINUTES);
        } else {
            key = (String)obj;
        }
        return key;
    }
}

