/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.mall.common.service;

import com.alibaba.fastjson.JSON;
import com.qqt.mall.common.service.PoolService;
import com.qqt.mall.common.service.SystemConfigService;
import com.qqt.platform.common.dto.CompanyApnDO;
import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.exception.BusinessException;
import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.service.SessionService;
import com.qqt.pool.api.request.PoolConfigBean;
import com.qqt.pool.base.DefaultPoolClient;
import com.qqt.pool.base.PoolClient;
import com.qqt.pool.base.request.PoolRequestBean;
import com.qqt.pool.base.response.PoolRespBean;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class PoolServiceImpl
implements PoolService {
    private final Logger log = LoggerFactory.getLogger(PoolServiceImpl.class);
    @Resource
    private AdminFeignService adminFeignService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private SessionService sessionService;
    @Autowired
    private RedisTemplate redisTemplate;
    private PoolClient poolClient = new DefaultPoolClient();
    private static final String APN_KEY_COMPANYID = "APN_KEY_COMPANYCODE_";
    private static final String POOL_BASE_URL = "POOL_BASE_URL";

    @Override
    public <T extends PoolRespBean> T service(PoolRequestBean poolRequestBean) {
        PoolRespBean execute = null;
        try {
            execute = this.poolClient.execute(this.getPoolBaseUrl(), poolRequestBean, this.getApnKeyByCompanyCode(poolRequestBean));
        }
        catch (IOException e) {
            e.printStackTrace();
            this.log.info("\u8c03\u7528\u5931\u8d25:{}", (Object)e.getMessage());
        }
        return (T)execute;
    }

    private String getPoolBaseUrl() {
        Object obj = this.redisTemplate.opsForValue().get((Object)POOL_BASE_URL);
        String poolBaseUrl = null;
        if (Objects.isNull(obj)) {
            poolBaseUrl = this.systemConfigService.getPoolBaseUrl();
            this.redisTemplate.opsForValue().set((Object)POOL_BASE_URL, (Object)poolBaseUrl, 30L, TimeUnit.MINUTES);
        } else {
            poolBaseUrl = (String)obj;
        }
        return poolBaseUrl;
    }

    private String getApnKeyByCompanyCode(PoolRequestBean request) {
        PoolConfigBean poolConfigBean = (PoolConfigBean)JSON.parseObject((String)JSON.toJSONString((Object)request), PoolConfigBean.class);
        if (Objects.isNull(poolConfigBean) && Objects.isNull(poolConfigBean.getCompanyCode())) {
            throw new BusinessException("company_code is empty", "\u516c\u53f8code\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.log.info("GetApnKeyByCompanyCode,\u5f53\u524d\u516c\u53f8CODE:{}", (Object)poolConfigBean.getCompanyCode());
        Object obj = this.redisTemplate.opsForValue().get((Object)(APN_KEY_COMPANYID + poolConfigBean.getCompanyCode()));
        String key = null;
        if (Objects.isNull(obj)) {
            ResultDTO resultDTO = this.adminFeignService.getCompanyApnByCode(poolConfigBean.getCompanyCode());
            key = ((CompanyApnDO)resultDTO.getData()).getKey();
            this.redisTemplate.opsForValue().set((Object)(APN_KEY_COMPANYID + poolConfigBean.getCompanyCode()), (Object)key, 15L, TimeUnit.MINUTES);
        } else {
            key = (String)obj;
        }
        return key;
    }
}

