/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.mall.common.transactionthread;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public abstract class TransactionAsycThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(TransactionAsycThread.class);
    private PlatformTransactionManager transactionManager;

    public TransactionAsycThread(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void run() {
        log.info("\u7ebf\u7a0b:{},\u5f00\u59cb\u5904\u7406", (Object)Thread.currentThread().getName());
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setPropagationBehavior(3);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)definition);
        try {
            this.doTransaction();
            this.transactionManager.commit(status);
        }
        catch (Exception e) {
            log.error("\u4e8b\u52a1\u7ebf\u7a0b\u53d1\u751f\u5f02\u5e38:{}", (Throwable)e);
            this.transactionManager.rollback(status);
        }
    }

    public abstract void doTransaction() throws Exception;
}

