/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.mall.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class FileUtils {
    public static void createFilePath(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static MultipartFile getMulFileByPath(String filePath) throws IOException {
        File file = new File(filePath);
        String fieldName = "file";
        CommonsMultipartFile multipartFile = null;
        FileInputStream inputStream = null;
        OutputStream outputStream = null;
        DiskFileItem fileItem = new DiskFileItem(fieldName, Files.probeContentType(file.toPath()), false, file.getName(), (int)file.length(), file.getParentFile());
        byte[] buffer = new byte[4096];
        try {
            int n;
            inputStream = new FileInputStream(file);
            outputStream = fileItem.getOutputStream();
            while ((n = ((InputStream)inputStream).read(buffer, 0, 4096)) != -1) {
                outputStream.write(buffer, 0, n);
            }
            multipartFile = new CommonsMultipartFile((FileItem)fileItem);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        finally {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return multipartFile;
    }

    public static void deleteFile(String pathName) {
        File file = new File(pathName);
        boolean value = file.delete();
        if (value) {
            System.out.println("JavaFile.java\u5df2\u6210\u529f\u5220\u9664.");
        } else {
            System.out.println("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
    }
}

