/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.mall.common.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qqt.platform.common.config.CommonConstants;
import com.qqt.platform.common.dto.CompanyDO;
import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.feign.AdminFeignService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SystemConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemConfigService.class);
    public static final String COPY_ADDRESS = "COPY_ADDRESS_";
    public static final String THIRD_COMPANYIDS = "THIRD_COMPANYIDS_";
    public static final String PLACE_ORDER_STRATEGY = "PLACE_ORDER_STRATEGY_";
    public static final String CREATE_CART_STRATEGY = "CREATE_CART_STRATEGY_";
    public static final String PRODUCT_STOCK_STRATEGY = "PRODUCT_STOCK_STRATEGY_";
    public static final String PRODUCT_PRICE_STRATEGY = "PRODUCT_PRICE_STRATEGY_";
    public static final String DELIVERYCOST_CALCULATION_STRATEGY = "DELIVERYCOST_CALCULATION_STRATEGY_";
    public static final String AUTO_APPROVAL = "AUTO_APPROVAL_";
    public static final String SYNCHRONIZE_IMAGE = "SYNCHRONIZE_IMAGE";
    public static final String LOCK_STOCK = "LOCK_STOCK_";
    public static final String AUTO_CONFIRM_JDORDER = "AUTO_CONFIRM_JDORDER_";
    public static final String AUTO_CONFIRM = "AUTO_CONFIRM";
    private static final String PREFIX_THIRD_MESSAGE = "THIRD_MESSAGE_";
    public static final String CHEEK_SHEET_STRATEGY = "CHEEK_SHEET_STRATEGY";
    public static final String CHECK_COMPRICE = "CHECK_COMPRICE";
    public static final String POOL_BASE_URL = "POOL_BASE_URL";
    public static final String USE_1688_CATEGORY = "USE_1688_CATEGORY";
    public static final String DATABASE_SCHEMA_PRODUCT = "DATABASE_SCHEMA_PRODUCT";
    public static final String DATABASE_SCHEMA_ORDER = "DATABASE_SCHEMA_ORDER";
    public static final String DATABASE_SCHEMA_ADMIN = "DATABASE_SCHEMA_ADMIN";
    public static final String INNERSALE_PO_STRATEGY = "INNERSALE_PO_STRATEGY_";
    public static final String SALE_IN_BUDGET_KEY = "SALE_IN_BUDGET_";
    public static final String ENABLE_BUDGETCHECK_FOR_PLACEORDER = "ENABLE_BUDGETCHECK_FOR_PLACEORDER";
    public static final String ENABLE_BUDGETCHECK_FOR_APPROVEORDER = "ENABLE_BUDGETCHECK_FOR_APPROVEORDER";
    public static final String ENABLE_BUDGETCHECK_BY_MONTH = "ENABLE_BUDGETCHECK_BY_MONTH";
    public static final String ENABLE_BUDGETCHECK_FOR_DELIVERYCOST = "ENABLE_BUDGETCHECK_FOR_DELIVERYCOST";
    public static final String DELIVERYCOST_BUDGETCLASS_CODE = "DELIVERYCOST_BUDGETCLASS_CODE";
    public static final String PURCHASE_MATRLNO_STRATEGY = "PURCHASE_MATRLNO_STRATEGY";
    public static final String ENABLE_PREORDER_FOR_CHECKOUT = "ENABLE_PREORDER_FOR_CHECKOUT";
    public static final String ENABLE_TOTALORDER_FOR_APPROVAL = "ENABLE_TOTALORDER_FOR_APPROVAL";
    public static final String ENABLE_COSTCENTER_FOR_CHECKOUT = "ENABLE_COSTCENTER_FOR_CHECKOUT";
    public static final String ENABLE_AUTO_SUBMIT_ORDER = "ENABLE_AUTO_SUBMIT_ORDER";
    public static final String THIRD_COMPANY_GROUPS = "THIRD_COMPANY_GROUPS";
    public static final String COMPANY_GROUP_ITEMS = "COMPANY_GROUP_ITEMS_";
    public static final String FLIGHT_PRICE_CACHE_MINUTES = "FLIGHT_PRICE_CACHE_MINUTES";
    public static final String PURCHASE_CONTRACT_QQT_STRATEGY = "PURCHASE_CONTRACT_QQT_STRATEGY";
    public static final String PURCHASE_CONTRACT_SELF_STRATEGY = "PURCHASE_CONTRACT_SELF_STRATEGY";
    public static final String FREE_PURCHASE_COMPANY_GROUP = "FREE_PURCHASE_COMPANY_GROUP";
    public static final String GROUT_SUB_COMPANY_THIRD = "GROUT_SUB_COMPANY_THIRD_";
    private static final String UNDERLINE = "_";
    public static final String ENABLE_TRANSFER_RULE = "ENABLE_TRANSFER_RULE";
    public static final String ENABLE_MULTI_STORE = "ENABLE_MULTI_STORE";
    @Autowired
    private AdminFeignService adminFeignService;
    @Autowired
    private SystemConfigService systemConfigService;
    public static final String THIRD_COMPANY_COMMON = "THIRD_COMPANY_COMMON_";
    public static final String THIRD_COMPANY_POOL_COMMON = "THIRD_COMPANY_POOL_COMMON_";

    public Boolean isCopyAddress(Long siteId) {
        ResponseEntity copyAddressOpt = this.adminFeignService.getSysValue(COPY_ADDRESS + siteId);
        if (copyAddressOpt != null && copyAddressOpt.getBody() != null) {
            try {
                return Boolean.parseBoolean((String)copyAddressOpt.getBody());
            }
            catch (Exception e) {
                LOGGER.error("copyAddress is error for site:" + siteId, (Throwable)e);
            }
        }
        return Boolean.FALSE;
    }

    public String getThirdCompanyIds(Long siteId) {
        ResponseEntity optional = this.adminFeignService.getSysValue(THIRD_COMPANYIDS + siteId);
        if (optional != null && optional.getBody() != null) {
            try {
                return (String)optional.getBody();
            }
            catch (Exception e) {
                LOGGER.error("copyAddress is error for site:" + siteId, (Throwable)e);
            }
        }
        return "";
    }

    public String getPlaceOrderBeanIdForSiteAndSupplyCompanyId(Long siteId, Long supplierCompanyId) {
        String thirdCompanyIds = this.getThirdCompanyIds(siteId);
        boolean isThirdCompany = Stream.of(thirdCompanyIds.split(",")).anyMatch(companyId -> companyId.equals(supplierCompanyId + ""));
        String placeOrderStrategy = "placeOrderStrategyImpl";
        if (isThirdCompany) {
            String systemConfigValueByCode;
            ResponseEntity responseEntity = this.adminFeignService.getSysValue(PLACE_ORDER_STRATEGY + siteId + UNDERLINE + supplierCompanyId);
            if (responseEntity != null && responseEntity.getBody() != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)((CharSequence)responseEntity.getBody()))) {
                placeOrderStrategy = (String)responseEntity.getBody();
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(systemConfigValueByCode = this.systemConfigService.getSystemConfigValueByCode(THIRD_COMPANY_COMMON + siteId + UNDERLINE + supplierCompanyId))) && "true".equals(systemConfigValueByCode)) {
                placeOrderStrategy = this.systemConfigService.getSystemConfigValueByCode(THIRD_COMPANY_POOL_COMMON + siteId + UNDERLINE + supplierCompanyId);
            }
        }
        return placeOrderStrategy;
    }

    public String getCreateCartStrategy(Long siteId, Long storeId) {
        ResponseEntity optional = this.adminFeignService.getSysValue(CREATE_CART_STRATEGY + siteId + UNDERLINE + storeId);
        if (optional != null && optional.getBody() != null) {
            try {
                return (String)optional.getBody();
            }
            catch (Exception e) {
                LOGGER.error("getCreateCartStrategy is error for site:" + siteId, (Throwable)e);
            }
        }
        return "createCartStrategyForSupplierImpl";
    }

    public Long getCompanyIdByCode(String code) {
        ResponseEntity result = this.adminFeignService.getSysValue(code);
        if (result != null && result.getBody() != null) {
            try {
                return Long.valueOf((String)result.getBody());
            }
            catch (Exception e) {
                LOGGER.error("\u6839\u636ejd\u516c\u53f8code\u83b7\u53d6\u516c\u53f8id\u5931\u8d25,code : " + code, (Throwable)e);
            }
        }
        return null;
    }

    public Boolean getAutoApproval(Long companyId, Long categoryId) {
        ResponseEntity resultByCompanyIdAndCategoryId = this.adminFeignService.getSysValue(AUTO_APPROVAL + companyId + UNDERLINE + categoryId);
        if (resultByCompanyIdAndCategoryId != null && resultByCompanyIdAndCategoryId.getBody() != null) {
            try {
                return Boolean.parseBoolean((String)resultByCompanyIdAndCategoryId.getBody());
            }
            catch (Exception e) {
                LOGGER.error("AutoApproval is error for companyId:" + companyId + " and categoryId:" + categoryId, (Throwable)e);
            }
        } else {
            ResponseEntity resultByCompanyId = this.adminFeignService.getSysValue(AUTO_APPROVAL + companyId);
            if (resultByCompanyId != null && resultByCompanyId.getBody() != null) {
                try {
                    return Boolean.parseBoolean((String)resultByCompanyId.getBody());
                }
                catch (Exception e) {
                    LOGGER.error("AutoApproval is error for companyId:" + companyId, (Throwable)e);
                }
            }
        }
        return Boolean.FALSE;
    }

    public String getSupplierProductStockStrategy(Long siteId, Long supplierId) {
        ResponseEntity optional = this.adminFeignService.getSysValue(PRODUCT_STOCK_STRATEGY + siteId + UNDERLINE + supplierId);
        if (optional != null && optional.getBody() != null) {
            try {
                return (String)optional.getBody();
            }
            catch (Exception e) {
                LOGGER.error("getSupplierProductStockStrategy is error for site:" + siteId, (Throwable)e);
            }
        }
        return "supplierProductStockStrategyImpl";
    }

    public String getDeliveryCostCalculationStrategy(Long siteId, Long supplierId) {
        ResponseEntity optional = this.adminFeignService.getSysValue(DELIVERYCOST_CALCULATION_STRATEGY + siteId + UNDERLINE + supplierId);
        if (optional != null && optional.getBody() != null) {
            try {
                return (String)optional.getBody();
            }
            catch (Exception e) {
                LOGGER.error("getDeliveryCostCalculationStrategy is error for site:" + siteId, (Throwable)e);
            }
        }
        return "deliveryCostCalculationStrategyImpl";
    }

    public String getSupplierProductPriceStrategy(Long siteId, Long supplierId) {
        ResponseEntity optional = this.adminFeignService.getSysValue(PRODUCT_PRICE_STRATEGY + siteId + UNDERLINE + supplierId);
        if (optional != null && optional.getBody() != null) {
            try {
                return (String)optional.getBody();
            }
            catch (Exception e) {
                LOGGER.error("getSupplierProductPriceStrategy is error for site:" + siteId, (Throwable)e);
            }
        }
        return "supplierProductPriceStrategyImpl";
    }

    public boolean getSynchronizeImage() {
        ResponseEntity result = this.adminFeignService.getSysValue(SYNCHRONIZE_IMAGE);
        if (result != null && result.getBody() != null) {
            try {
                return "true".equals(result.getBody());
            }
            catch (Exception e) {
                LOGGER.error("\u662f\u5426\u540c\u6b65\u56fe\u7247\u5931\u8d25,code : SYNCHRONIZE_IMAGE", (Throwable)e);
            }
        }
        return false;
    }

    public boolean getLockStock(Long siteId, Long companyId, Long supplierId) {
        ResponseEntity optional = this.adminFeignService.getSysValue(LOCK_STOCK + siteId + UNDERLINE + companyId + UNDERLINE + supplierId);
        if (optional != null && optional.getBody() != null) {
            try {
                return "true".equals(optional.getBody());
            }
            catch (Exception e) {
                LOGGER.error("getSupplierProductPriceStrategy is error for site:" + siteId, (Throwable)e);
            }
        }
        return true;
    }

    public String getThirdMessage(String type) {
        ResponseEntity optional = this.adminFeignService.getSysValue(PREFIX_THIRD_MESSAGE + type);
        if (optional != null && optional.getBody() != null) {
            try {
                return (String)optional.getBody();
            }
            catch (Exception e) {
                LOGGER.error("getThirdMessage is error for type:" + type, (Throwable)e);
            }
        }
        return "defaultMessageImpl";
    }

    public String getReturnOrderBeanIdByCode(String code) {
        String placeOrderStrategy = "returnOrderStrategyImpl";
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)code)) {
            placeOrderStrategy = placeOrderStrategy.replace("Impl", "For");
            placeOrderStrategy = placeOrderStrategy.concat(code);
            if (!("JD".equals(code) || "SN".equals(code) || "QX".equals(code))) {
                placeOrderStrategy = placeOrderStrategy.replace(code, "Common");
            }
            if ("FREE".equals(code)) {
                placeOrderStrategy = placeOrderStrategy.replace(code, "Common");
            }
        }
        return placeOrderStrategy;
    }

    public boolean getAutoConfirmJDOrder(Long siteId, Long companyId) {
        ResponseEntity optional = this.adminFeignService.getSysValue(AUTO_CONFIRM_JDORDER + siteId + UNDERLINE + companyId);
        if (optional != null && optional.getBody() != null) {
            try {
                return "true".equals(optional.getBody());
            }
            catch (Exception e) {
                LOGGER.error("getAutoConfirmJDOrder is error for companyId:" + companyId, (Throwable)e);
            }
        }
        if ((optional = this.adminFeignService.getSysValue(AUTO_CONFIRM_JDORDER + siteId)) != null && optional.getBody() != null) {
            try {
                return "true".equals(optional.getBody());
            }
            catch (Exception e) {
                LOGGER.error("getAutoConfirmJDOrder is error for siteId:" + siteId, (Throwable)e);
            }
        }
        return false;
    }

    public String getCheckSheetStrategyForSiteAndCode(Long siteId, String code) {
        String checkSheetStrategy = "";
        ResponseEntity responseEntity = this.adminFeignService.getSysValue("CHEEK_SHEET_STRATEGY_" + code);
        if (responseEntity != null && responseEntity.getBody() != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)((CharSequence)responseEntity.getBody()))) {
            checkSheetStrategy = (String)responseEntity.getBody();
        }
        return checkSheetStrategy;
    }

    public Boolean getCheckCompriceForCode(String code) {
        ResultDTO resultDTO = this.adminFeignService.getSystemOptionItemValForBoolean("noMinPricePlaceOrder");
        if (resultDTO.isSuccess() && resultDTO.getData() != null) {
            return (Boolean)resultDTO.getData();
        }
        return Boolean.FALSE;
    }

    public boolean getAutoConfirmThirdCompanyOrder(Long siteId, Long companyId, String outerSysA) {
        StringJoiner joiner0;
        String sysKey0;
        ResponseEntity optional0;
        StringJoiner joiner = new StringJoiner(UNDERLINE);
        String sysKey = joiner.add(AUTO_CONFIRM).add(outerSysA).add(String.valueOf(siteId)).add(String.valueOf(companyId)).toString();
        LOGGER.debug("getAutoConfirmThirdCompanyOrder|sysKey:{}", (Object)sysKey);
        ResponseEntity optional = this.adminFeignService.getSysValue(sysKey);
        if (optional != null && optional.getBody() != null) {
            try {
                return "true".equals(optional.getBody());
            }
            catch (Exception e) {
                LOGGER.error("getAutoConfirm" + outerSysA + " is error for companyId:" + companyId, (Throwable)e);
            }
        }
        if ((optional0 = this.adminFeignService.getSysValue(sysKey0 = (joiner0 = new StringJoiner(UNDERLINE)).add(AUTO_CONFIRM).add(outerSysA).add(String.valueOf(siteId)).toString())) != null && optional0.getBody() != null) {
            try {
                return "true".equals(optional0.getBody());
            }
            catch (Exception e) {
                LOGGER.error("getAutoConfirmJDOrder is error for siteId:" + siteId, (Throwable)e);
            }
        }
        return false;
    }

    public String getSystemConfigValueByCode(String code) {
        ResponseEntity result = this.adminFeignService.getSysValue(code);
        if (result != null && result.getBody() != null) {
            try {
                return (String)result.getBody();
            }
            catch (Exception e) {
                LOGGER.error("getSystemConfigValueByCode happend error,code : " + code, (Throwable)e);
            }
        }
        return "";
    }

    public String getDatabaseSchemaProduct() {
        String schema = this.getSystemConfigValueByCode(DATABASE_SCHEMA_PRODUCT);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)schema)) {
            schema = "qqt_mall_product";
        }
        return schema;
    }

    public String getDatabaseSchemaOrder() {
        String schema = this.getSystemConfigValueByCode(DATABASE_SCHEMA_ORDER);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)schema)) {
            schema = "qqt_mall_order";
        }
        return schema;
    }

    public String getDatabaseSchemaAdmin() {
        String schema = this.getSystemConfigValueByCode(DATABASE_SCHEMA_ADMIN);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)schema)) {
            schema = "qqt_platform_admin";
        }
        return schema;
    }

    public String getPoolBaseUrl() {
        ResponseEntity optional = this.adminFeignService.getSysValue(POOL_BASE_URL);
        if (optional != null && optional.getBody() != null) {
            try {
                return (String)optional.getBody();
            }
            catch (Exception e) {
                LOGGER.error("getPoolBaseUrl is error :", (Throwable)e);
            }
        }
        return null;
    }

    public String getInnerSaleStrategy(Long companyId) {
        ResponseEntity optional = this.adminFeignService.getSysValue(INNERSALE_PO_STRATEGY + companyId);
        if (optional != null && optional.getBody() != null) {
            try {
                return (String)optional.getBody();
            }
            catch (Exception e) {
                LOGGER.error("getInnerSaleStrategy is error :", (Throwable)e);
            }
        }
        return "SUBCOMPANY";
    }

    public String getValue(String key) {
        String checkSheetStrategy = "";
        ResponseEntity responseEntity = this.adminFeignService.getSysValue(key);
        if (responseEntity != null && responseEntity.getBody() != null && !StringUtils.isEmpty((Object)responseEntity.getBody())) {
            checkSheetStrategy = (String)responseEntity.getBody();
        }
        return checkSheetStrategy;
    }

    public Boolean getEnableBudgetCheckForPlaceOrder(Long companyId) {
        ResultDTO resultDTO = this.adminFeignService.getSystemOptionItemValForString(CommonConstants.SystemOptionItemKeyVal.budgetCheck.getItemKey());
        if (resultDTO.isSuccess() && resultDTO.getData() != null) {
            String data = (String)resultDTO.getData();
            if (CommonConstants.SystemOptionItemKeyVal.budgetCheck.getSelectTwo().equals(data)) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Boolean getEnableMonthBudget(Long companyId) {
        return this.getValueByKey(companyId, ENABLE_BUDGETCHECK_BY_MONTH, Boolean.FALSE);
    }

    public Boolean getValueByKey(Long companyId, String key, Boolean defValue) {
        ResponseEntity optional = companyId == null ? this.adminFeignService.getSysValue(key) : this.adminFeignService.getSysValue(companyId, key);
        if (optional != null && optional.getBody() != null) {
            try {
                return Boolean.parseBoolean((String)optional.getBody());
            }
            catch (Exception e) {
                LOGGER.error("getValueByKey is error,companyId:" + companyId + ",key:" + key, (Throwable)e);
            }
        }
        return defValue;
    }

    public String getValueByKey(Long companyId, String key, String defValue) {
        ResponseEntity optional = companyId == null ? this.adminFeignService.getSysValue(key) : this.adminFeignService.getSysValue(companyId, key);
        if (optional != null && optional.getBody() != null) {
            try {
                return (String)optional.getBody();
            }
            catch (Exception e) {
                LOGGER.error("getValueByKey is error,companyId:" + companyId + ",key:" + key, (Throwable)e);
            }
        }
        return defValue;
    }

    public boolean getEnableBudgetCheckForApproveOrder(Long companyId) {
        return this.getValueByKey(companyId, ENABLE_BUDGETCHECK_FOR_APPROVEORDER, Boolean.FALSE);
    }

    public boolean getEnableBudgetCheckForDeliveryCost(Long companyId) {
        return this.getValueByKey(companyId, ENABLE_BUDGETCHECK_FOR_DELIVERYCOST, Boolean.FALSE);
    }

    public String getDeliveryCostBudgetClassCode(Long companyId) {
        return this.getValueByKey(companyId, DELIVERYCOST_BUDGETCLASS_CODE, "");
    }

    public String getPurchaseMatrlNoStrategy(Long companyId) {
        return this.getValueByKey(companyId, PURCHASE_MATRLNO_STRATEGY, "purchaseMatrlNoStrategyByPlatformImpl");
    }

    public Boolean getEnablePreOrderForCheckout(Long companyId) {
        return Boolean.TRUE;
    }

    public Boolean getEnableTotalOrderForApproval(Long companyId) {
        ResultDTO resultDTO = this.adminFeignService.getSystemOptionItemValForBoolean("thirdMergeOrder");
        if (resultDTO.isSuccess() && resultDTO.getData() != null) {
            return (Boolean)resultDTO.getData();
        }
        return Boolean.TRUE;
    }

    public Boolean getEnableCostcenterForCheckout(Long companyId) {
        ResultDTO resultDTO = this.adminFeignService.getSystemOptionItemValForBoolean("ifCostCenter");
        if (resultDTO.isSuccess() && resultDTO.getData() != null) {
            return (Boolean)resultDTO.getData();
        }
        return Boolean.FALSE;
    }

    public Boolean getEnableAutoSubmitOrder(Long companyId) {
        ResultDTO resultDTO = this.adminFeignService.getSystemOptionItemValForBoolean("orderAutoSubmit");
        if (resultDTO.isSuccess() && resultDTO.getData() != null) {
            return (Boolean)resultDTO.getData();
        }
        return Boolean.TRUE;
    }

    public List<String> getThirdCompanyGroups() {
        String companyGroups = this.getValue(THIRD_COMPANY_GROUPS);
        if (org.apache.commons.lang3.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{companyGroups})) {
            return Arrays.stream(companyGroups.split(",")).map(String::trim).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public List<String> getCompanyGroupItems(String trim) {
        String companyGroupItems = this.getValue(COMPANY_GROUP_ITEMS + trim);
        if (org.apache.commons.lang3.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{companyGroupItems})) {
            return Arrays.stream(companyGroupItems.split(",")).map(String::trim).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public String getFlightPriceCacheMinutes() {
        return this.getValueByKey(null, FLIGHT_PRICE_CACHE_MINUTES, "10");
    }

    public String getPurchaseContractStrategy(Long companyId, String companyCode) {
        List<String> selfCompanyIds;
        boolean isSelfContract;
        List<String> contractCompanyIds;
        boolean isQqtContract;
        StringJoiner qqtJoiner = new StringJoiner(UNDERLINE);
        qqtJoiner.add(PURCHASE_CONTRACT_QQT_STRATEGY).add(companyCode);
        String qqtContract = this.getValueByKey(null, qqtJoiner.toString(), "");
        if (!Strings.isBlank((String)qqtContract) && !Objects.isNull(qqtContract) && (isQqtContract = (contractCompanyIds = Arrays.asList(qqtContract.split(","))).contains(companyId + ""))) {
            return "QQT";
        }
        StringJoiner joiner = new StringJoiner(UNDERLINE);
        joiner.add(PURCHASE_CONTRACT_SELF_STRATEGY).add(companyCode);
        String selfContract = this.getValueByKey(null, joiner.toString(), "");
        if (!Strings.isBlank((String)selfContract) && !Objects.isNull(selfContract) && (isSelfContract = (selfCompanyIds = Arrays.asList(selfContract.split(","))).contains(companyId + ""))) {
            return "SELF";
        }
        return null;
    }

    public String getAutoConfirm(Long companyId, String companyCode) {
        List<String> selfCompanyIds;
        boolean isSelfContract;
        StringJoiner joiner = new StringJoiner(UNDERLINE);
        joiner.add(PURCHASE_CONTRACT_SELF_STRATEGY).add(companyCode);
        String selfContract = this.getValueByKey(null, joiner.toString(), "");
        if (!Strings.isBlank((String)selfContract) && !Objects.isNull(selfContract) && (isSelfContract = (selfCompanyIds = Arrays.asList(selfContract.split(","))).contains(companyId + ""))) {
            return "SELF";
        }
        return "";
    }

    public Boolean getNoManageOrgPlaceOrder() {
        ResultDTO resultDTO = this.adminFeignService.getSystemOptionItemValForBoolean("noManageOrgPlaceOrder");
        if (resultDTO.isSuccess() && resultDTO.getData() != null) {
            return (Boolean)resultDTO.getData();
        }
        return Boolean.TRUE;
    }

    public String getStockLockValidate() {
        ResultDTO resultDTO = this.adminFeignService.getSystemOptionItemValForString(CommonConstants.SystemOptionItemKeyVal.stockLockValidate.getItemKey());
        if (resultDTO.isSuccess() && resultDTO.getData() != null) {
            return (String)resultDTO.getData();
        }
        return CommonConstants.SystemOptionItemKeyVal.stockLockValidate.getSelectOne();
    }

    public Boolean getBuyExplain() {
        ResultDTO resultDTO = this.adminFeignService.getSystemOptionItemValForString(CommonConstants.SystemOptionItemKeyVal.buyExplain.getItemKey());
        if (resultDTO.isSuccess() && resultDTO.getData() != null && !CommonConstants.SystemOptionItemKeyVal.buyExplain.getSelectOne().equals(resultDTO.getData())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getPRequestDataAuth() {
        ResultDTO resultDTO = this.adminFeignService.getSystemOptionItemValForString(CommonConstants.SystemOptionItemKeyVal.pRequestDataAuth.getItemKey());
        if (resultDTO.isSuccess() && resultDTO.getData() != null) {
            return (String)resultDTO.getData();
        }
        return CommonConstants.SystemOptionItemKeyVal.pRequestDataAuth.getSelectOne();
    }

    public String getPRequestOperateAuth() {
        ResultDTO resultDTO = this.adminFeignService.getSystemOptionItemValForString(CommonConstants.SystemOptionItemKeyVal.pRequestOperateAuth.getItemKey());
        if (resultDTO.isSuccess() && resultDTO.getData() != null) {
            return (String)resultDTO.getData();
        }
        return CommonConstants.SystemOptionItemKeyVal.pRequestOperateAuth.getSelectOne();
    }

    public String getBudgetCheck() {
        ResultDTO resultDTO = this.adminFeignService.getSystemOptionItemValForString(CommonConstants.SystemOptionItemKeyVal.budgetCheck.getItemKey());
        if (resultDTO.isSuccess() && resultDTO.getData() != null) {
            return (String)resultDTO.getData();
        }
        return CommonConstants.SystemOptionItemKeyVal.budgetCheck.getSelectTwo();
    }

    public List<String> getFreePurchaseCompanyGroups() {
        String companyGroups = this.getValue(FREE_PURCHASE_COMPANY_GROUP);
        if (org.apache.commons.lang3.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{companyGroups})) {
            return Arrays.stream(companyGroups.split(",")).map(String::trim).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public String getSubCompanyCodeBySysA(String sysA) {
        return this.getValue(GROUT_SUB_COMPANY_THIRD + sysA.toUpperCase());
    }

    public String getThirdCodeBySiteAndSupplierIdAndSysKey(String sysKey, Long siteId, Long supplierCompanyId) {
        String temporary = this.getTemporaryCode(supplierCompanyId);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)temporary)) {
            return temporary;
        }
        CompanyDO companyDO = this.getCompanyCode(supplierCompanyId);
        if (companyDO == null) {
            return this.getSystemConfigValueByCode(sysKey + siteId + UNDERLINE + supplierCompanyId);
        }
        return companyDO.getCode();
    }

    public String getThirdYylBySiteAndSupplierIdAndSysKey(String sysKey, Long siteId, Long companyId) {
        String temporary = this.getTemporaryYyldx(companyId);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)temporary)) {
            return temporary;
        }
        CompanyDO companyDO = this.getCompanyCode(companyId);
        if (companyDO == null) {
            return this.getSystemConfigValueByCode(sysKey + siteId + UNDERLINE + companyId);
        }
        String companyType = companyDO.getCompanyType();
        if ("FREE_SUPPLIER".equalsIgnoreCase(companyType)) {
            return "FREE";
        }
        return companyDO.getCode();
    }

    private CompanyDO getCompanyCode(Long companyId) {
        ResponseEntity responseEntity = this.adminFeignService.getOneCompanyById(companyId);
        if (responseEntity != null && responseEntity.getBody() != null) {
            return (CompanyDO)((ResultDTO)responseEntity.getBody()).getData();
        }
        return null;
    }

    private String getTemporaryCode(Long companyId) {
        String FREE_COMPANY_APPOINT = "FREE_COMPANY_APPOINT";
        String temporaryJson = this.getSystemConfigValueByCode("FREE_COMPANY_APPOINT");
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)temporaryJson)) {
            JSONArray jsonArray = JSON.parseArray((String)temporaryJson);
            for (Object obj : jsonArray) {
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(obj));
                Long sourceId = jsonObject.getLong("sourceId");
                String targetCode = jsonObject.getString("targetCode");
                if (!companyId.equals(sourceId)) continue;
                return targetCode;
            }
        }
        return "";
    }

    private String getTemporaryYyldx(Long companyId) {
        String FREE_COMPANY_APPOINT = "FREE_COMPANY_APPOINT";
        String temporaryJson = this.getSystemConfigValueByCode("FREE_COMPANY_APPOINT");
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)temporaryJson)) {
            JSONArray jsonArray = JSON.parseArray((String)temporaryJson);
            for (Object obj : jsonArray) {
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(obj));
                Long sourceId = jsonObject.getLong("sourceId");
                if (!companyId.equals(sourceId)) continue;
                return "FREE";
            }
        }
        return "";
    }

    public Boolean getEnableTransferRule(Long companyId) {
        ResultDTO resultDTO = this.adminFeignService.getSystemOptionItemValForBoolean("enableTransferRule", companyId);
        if (resultDTO.isSuccess() && resultDTO.getData() != null) {
            return (Boolean)resultDTO.getData();
        }
        return Boolean.FALSE;
    }

    public Boolean getEnableMultiStore(Long companyId) {
        return this.getValueByKey(companyId, ENABLE_MULTI_STORE, Boolean.FALSE);
    }
}

