/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.mall.common.util;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String url, Map<String, String> param, Map<String, String> headers) {
        CloseableHttpClient httpClient = null;
        String resultString = "";
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpClients.createDefault();
            URIBuilder builder = new URIBuilder(url);
            if (!CollectionUtils.isEmpty(param)) {
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    builder.addParameter(entry.getKey(), entry.getValue());
                }
            }
            URI uri = builder.build();
            HttpGet httpGet = new HttpGet(uri);
            if (!CollectionUtils.isEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpGet.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)httpGet)).getStatusLine().getStatusCode() == 200) {
                resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            log.error("httpGet\u8c03\u7528\u5f02\u5e38:", (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                log.error("httpClient-httpGet\u5173\u95ed\u5f02\u5e38:", (Throwable)e);
            }
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String url, String json, Map<String, String> headers) {
        CloseableHttpClient httpClient = null;
        String resultString = "";
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json");
            if (!CollectionUtils.isEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            StringEntity entity = new StringEntity(json, Charset.forName("UTF-8"));
            entity.setContentEncoding("UTF-8");
            entity.setContentType("application/json;charset=UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() == 200) {
                resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            log.error("httpPost\u8c03\u7528\u5f02\u5e38:", (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                log.error("httpClient-httpPost\u5173\u95ed\u5f02\u5e38:", (Throwable)e);
            }
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpsGet(String url, Map<String, String> param, Map<String, String> headers) {
        CloseableHttpClient hp = null;
        String resultString = "";
        CloseableHttpResponse response = null;
        try {
            hp = HttpUtils.createSSLClientDefault();
            URIBuilder builder = new URIBuilder(url);
            if (!CollectionUtils.isEmpty(param)) {
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    builder.addParameter(entry.getKey(), entry.getValue());
                }
            }
            URI uri = builder.build();
            HttpGet hg = new HttpGet(uri);
            if (!CollectionUtils.isEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    hg.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = hp.execute((HttpUriRequest)hg)).getStatusLine().getStatusCode() == 200) {
                resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            log.error("httpsGet\u8c03\u7528\u5f02\u5e38:", (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (hp != null) {
                    hp.close();
                }
            }
            catch (IOException e) {
                log.error("httpClient-httpsGet\u5173\u95ed\u5f02\u5e38:", (Throwable)e);
            }
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpsPostJson(String url, String json, Map<String, String> headers) {
        CloseableHttpClient hp = null;
        String resultString = "";
        CloseableHttpResponse response = null;
        try {
            hp = HttpUtils.createSSLClientDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json");
            if (!CollectionUtils.isEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            StringEntity entity = new StringEntity(json, Charset.forName("UTF-8"));
            entity.setContentEncoding("UTF-8");
            entity.setContentType("application/json;charset=UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            response = hp.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() == 200) {
                resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            log.error("httpsPostJson\u8c03\u7528\u5f02\u5e38:", (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (hp != null) {
                    hp.close();
                }
            }
            catch (IOException e) {
                log.error("httpClient-httpsPostJson\u5173\u95ed\u5f02\u5e38:", (Throwable)e);
            }
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpsPostForm(String url, Map<String, String> param, Map<String, String> headers) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            httpClient = HttpUtils.createSSLClientDefault();
            HttpPost httpPost = new HttpPost(url);
            if (!CollectionUtils.isEmpty(param)) {
                ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    paramList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList);
                httpPost.setEntity((HttpEntity)entity);
            }
            if (!CollectionUtils.isEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() == 200) {
                resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            log.error("httpsPostForm\u8c03\u7528\u5f02\u5e38:", (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                log.error("httpClient-httpsPostForm\u5173\u95ed\u5f02\u5e38:", (Throwable)e);
            }
        }
        return resultString;
    }

    public static CloseableHttpClient createSSLClientDefault() throws Exception {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }
}

