/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.admin.feign;

import com.alibaba.fastjson.JSONObject;
import com.qqt.platform.admin.security.SecurityUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class CommonFeignClientInterceptor
implements RequestInterceptor {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER = "Bearer";

    public void apply(RequestTemplate template) {
        Optional<String> optional = SecurityUtils.getCurrentUserJWT();
        if (optional.isPresent()) {
            template.header(AUTHORIZATION_HEADER, new String[]{String.format("%s %s", BEARER, optional.get())});
        } else {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null) {
                HttpServletRequest request = attributes.getRequest();
                String token = request.getHeader(AUTHORIZATION_HEADER);
                template.header(AUTHORIZATION_HEADER, new String[]{token});
            } else {
                JSONObject json;
                String token;
                Object object;
                String requestBody = template.requestBody().asString();
                if (!StringUtils.isEmpty((Object)requestBody) && (object = JSONObject.parse((String)requestBody)) instanceof JSONObject && !StringUtils.isEmpty((Object)(token = (json = (JSONObject)object).getString("token")))) {
                    template.header(AUTHORIZATION_HEADER, new String[]{token});
                }
            }
        }
    }
}

