/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.event;

import com.qqt.platform.common.dto.LogErrorDTO;
import com.qqt.platform.common.event.ErrorLogEvent;
import com.qqt.platform.common.utils.Exceptions;
import com.qqt.platform.common.utils.LogAbstractUtil;
import com.qqt.platform.common.utils.SpringUtils;
import com.qqt.platform.common.utils.WebUtil;
import java.util.HashMap;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.ObjectUtils;

public class ErrorLogPublisher {
    public static void publishEvent(Throwable error, String requestUri) {
        HttpServletRequest request = WebUtil.getRequest();
        LogErrorDTO logError = new LogErrorDTO();
        logError.setRequestUri(requestUri);
        if (!Objects.isNull(error)) {
            logError.setStackTrace(Exceptions.getStackTraceAsString(error));
            logError.setExceptionName(error.getClass().getName());
            logError.setMessage(error.getMessage());
            Object[] elements = error.getStackTrace();
            if (!ObjectUtils.isEmpty((Object[])elements)) {
                Object element = elements[0];
                logError.setMethodName(((StackTraceElement)element).getMethodName());
                logError.setMethodClass(((StackTraceElement)element).getClassName());
                logError.setFileName(((StackTraceElement)element).getFileName());
                logError.setLineNumber(((StackTraceElement)element).getLineNumber());
            }
        }
        LogAbstractUtil.addRequestInfoToLog(request, logError);
        HashMap<String, Object> event = new HashMap<String, Object>(16);
        event.put("info", logError);
        SpringUtils.publishEvent(new ErrorLogEvent(event));
    }
}

