/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.config;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.PackageVersion;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.qqt.platform.common.config.InstantDeserializer;
import com.qqt.platform.common.config.InstantSerializer;
import com.qqt.platform.common.utils.DateUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;

public class SimpleTimeModule
extends SimpleModule {
    public static final SimpleTimeModule INSTANCE = new SimpleTimeModule();

    public SimpleTimeModule() {
        super(PackageVersion.VERSION);
        this.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateUtil.DATETIME_FORMAT));
        this.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateUtil.DATE_FORMAT));
        this.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateUtil.TIME_FORMAT));
        this.addDeserializer(Instant.class, (JsonDeserializer)new InstantDeserializer(DateUtil.DATETIME_FORMAT.withZone(ZoneId.systemDefault())));
        this.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateUtil.DATETIME_FORMAT));
        this.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateUtil.DATE_FORMAT));
        this.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateUtil.TIME_FORMAT));
        this.addSerializer(Instant.class, (JsonSerializer)new InstantSerializer(DateUtil.DATETIME_FORMAT.withZone(ZoneId.systemDefault())));
    }
}

