/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.transactionthread;

import com.qqt.platform.common.transactionthread.TransactionExecute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class ThreadTransactionUtil {
    private static final Logger log = LoggerFactory.getLogger(ThreadTransactionUtil.class);
    private CountDownLatch rollbackLatch = new CountDownLatch(1);
    private AtomicBoolean rollbackFlag = new AtomicBoolean(false);
    private CountDownLatch threadLatch;
    private List<TransactionExecute> executeList;
    private PlatformTransactionManager transactionManager;
    private Executor taskExecutor;
    private List<String> errorMsg = new ArrayList<String>();

    public ThreadTransactionUtil(List<TransactionExecute> list, PlatformTransactionManager transactionManager, Executor taskExecutor) {
        this.executeList = list;
        this.transactionManager = transactionManager;
        this.taskExecutor = taskExecutor;
        if (CollectionUtils.isNotEmpty(list)) {
            this.threadLatch = new CountDownLatch(list.size());
        }
    }

    public void runTransaction() {
        if (CollectionUtils.isEmpty(this.executeList)) {
            return;
        }
        log.info("\u4e8b\u52a1\u7ebf\u7a0b\u4e2a\u6570\uff1a{}", (Object)this.executeList.size());
        for (TransactionExecute transactionExecute : this.executeList) {
            this.taskExecutor.execute(() -> {
                if (this.rollbackFlag.get()) {
                    return;
                }
                log.info("\u7ebf\u7a0b:{},\u5f00\u59cb\u5904\u7406", (Object)Thread.currentThread().getName());
                DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
                definition.setPropagationBehavior(3);
                TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)definition);
                try {
                    transactionExecute.execute();
                    this.threadLatch.countDown();
                    log.info("\u7ebf\u7a0b:{},\u7b49\u5f85", (Object)Thread.currentThread().getName());
                    this.rollbackLatch.await();
                    log.info("\u7ebf\u7a0b:{},\u7ee7\u7eed\u5904\u7406\uff0c\u56de\u6eda\u6807\u8bc6:{}", (Object)Thread.currentThread().getName(), (Object)this.rollbackFlag.get());
                    if (this.rollbackFlag.get()) {
                        this.transactionManager.rollback(status);
                    } else {
                        this.transactionManager.commit(status);
                    }
                }
                catch (Exception e) {
                    log.error("\u4e8b\u52a1\u7ebf\u7a0b\u7684\u4e1a\u52a1\u62a5\u9519\uff1a{}", (Throwable)e);
                    this.errorMsg.add(e.getMessage());
                    this.rollbackFlag.set(true);
                    this.rollbackLatch.countDown();
                    this.threadLatch.countDown();
                    this.transactionManager.rollback(status);
                }
            });
        }
    }

    public void awaitOrRelease() throws Exception {
        try {
            log.info("\u4e3b\u7ebf\u7ebf\u7a0b\u963b\u585e\uff0c\u56de\u6eda\u6807\u8bc6:{}", (Object)this.rollbackFlag.get());
            if (!this.rollbackFlag.get()) {
                this.threadLatch.await();
                this.rollbackLatch.countDown();
            }
        }
        catch (InterruptedException e) {
            log.error("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38\uff1a{}", (Throwable)e);
            throw e;
        }
    }

    public void rollback() {
        this.rollbackFlag.set(true);
        this.rollbackLatch.countDown();
    }

    public List<String> getErrorMsg() {
        return this.errorMsg;
    }
}

