/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.web;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import javax.annotation.PostConstruct;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/groovy/script"})
public class GroovyScriptController {
    public static final Logger LOGGER = LoggerFactory.getLogger(GroovyScriptController.class);
    @Autowired
    private Binding groovyBinding;
    private GroovyShell groovyShell;

    @PostConstruct
    public void init() {
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.getClass().getClassLoader());
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.setSourceEncoding("utf-8");
        this.groovyShell = new GroovyShell((ClassLoader)groovyClassLoader, this.groovyBinding, compilerConfiguration);
    }

    @RequestMapping(value={"/execute"}, method={RequestMethod.POST})
    public String execute(@RequestBody String scriptContent) {
        LOGGER.info("script: " + scriptContent);
        Script script = this.groovyShell.parse(scriptContent);
        Object obj = script.run();
        LOGGER.info("result: " + scriptContent);
        return String.valueOf(obj);
    }
}

