/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.redis.cache;

import com.qqt.platform.redis.cache.CacheKey;
import com.qqt.platform.tool.utils.CollectionUtil;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@Deprecated
public class BladeRedisCache {
    private final RedisTemplate<String, Object> redisTemplate;
    private final ValueOperations<String, Object> valueOps;
    private final HashOperations<String, Object, Object> hashOps;
    private final ListOperations<String, Object> listOps;
    private final SetOperations<String, Object> setOps;
    private final ZSetOperations<String, Object> zSetOps;

    public BladeRedisCache(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
        Assert.notNull(redisTemplate, (String)"redisTemplate is null");
        this.valueOps = redisTemplate.opsForValue();
        this.hashOps = redisTemplate.opsForHash();
        this.listOps = redisTemplate.opsForList();
        this.setOps = redisTemplate.opsForSet();
        this.zSetOps = redisTemplate.opsForZSet();
    }

    public void set(CacheKey cacheKey, Object value) {
        String key = cacheKey.getKey();
        Duration expire = cacheKey.getExpire();
        if (expire == null) {
            this.set(key, value);
        } else {
            this.setEx(key, value, expire);
        }
    }

    public void set(String key, Object value) {
        this.valueOps.set((Object)key, value);
    }

    public void setEx(String key, Object value, Duration timeout) {
        this.valueOps.set((Object)key, value, timeout);
    }

    public void setEx(String key, Object value, Long seconds) {
        this.valueOps.set((Object)key, value, seconds.longValue(), TimeUnit.SECONDS);
    }

    @Nullable
    public <T> T get(String key) {
        return (T)this.valueOps.get((Object)key);
    }

    @Nullable
    public <T> T get(String key, Supplier<T> loader) {
        T value = this.get(key);
        if (value != null) {
            return value;
        }
        value = loader.get();
        if (value == null) {
            return null;
        }
        this.set(key, value);
        return value;
    }

    @Nullable
    public <T> T get(CacheKey cacheKey) {
        return (T)this.valueOps.get((Object)cacheKey.getKey());
    }

    @Nullable
    public <T> T get(CacheKey cacheKey, Supplier<T> loader) {
        String key = cacheKey.getKey();
        T value = this.get(key);
        if (value != null) {
            return value;
        }
        value = loader.get();
        if (value == null) {
            return null;
        }
        this.set(cacheKey, value);
        return value;
    }

    public Boolean del(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    public Boolean del(CacheKey key) {
        return this.redisTemplate.delete((Object)key.getKey());
    }

    public Long del(String ... keys) {
        return this.del(Arrays.asList(keys));
    }

    public Long del(Collection<String> keys) {
        return this.redisTemplate.delete(keys);
    }

    public Set<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public void mSet(Object ... keysValues) {
        this.valueOps.multiSet(CollectionUtil.toMap((Object[])keysValues));
    }

    public List<Object> mGet(String ... keys) {
        return this.mGet(Arrays.asList(keys));
    }

    public List<Object> mGet(Collection<String> keys) {
        return this.valueOps.multiGet(keys);
    }

    public Long decr(String key) {
        return this.valueOps.decrement((Object)key);
    }

    public Long decrBy(String key, long longValue) {
        return this.valueOps.decrement((Object)key, longValue);
    }

    public Long incr(String key) {
        return this.valueOps.increment((Object)key);
    }

    public Long incrBy(String key, long longValue) {
        return this.valueOps.increment((Object)key, longValue);
    }

    public Long getCounter(String key) {
        return Long.valueOf(String.valueOf(this.valueOps.get((Object)key)));
    }

    public Boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public String randomKey() {
        return (String)this.redisTemplate.randomKey();
    }

    public void rename(String oldkey, String newkey) {
        this.redisTemplate.rename((Object)oldkey, (Object)newkey);
    }

    public Boolean move(String key, int dbIndex) {
        return this.redisTemplate.move((Object)key, dbIndex);
    }

    public Boolean expire(String key, long seconds) {
        return this.redisTemplate.expire((Object)key, seconds, TimeUnit.SECONDS);
    }

    public Boolean expire(String key, Duration timeout) {
        return this.expire(key, timeout.getSeconds());
    }

    public Boolean expireAt(String key, Date date) {
        return this.redisTemplate.expireAt((Object)key, date);
    }

    public Boolean expireAt(String key, long unixTime) {
        return this.expireAt(key, new Date(unixTime));
    }

    public Boolean pexpire(String key, long milliseconds) {
        return this.redisTemplate.expire((Object)key, milliseconds, TimeUnit.MILLISECONDS);
    }

    public <T> T getSet(String key, Object value) {
        return (T)this.valueOps.getAndSet((Object)key, value);
    }

    public Boolean persist(String key) {
        return this.redisTemplate.persist((Object)key);
    }

    public String type(String key) {
        return this.redisTemplate.type((Object)key).code();
    }

    public Long ttl(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    public Long pttl(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.MILLISECONDS);
    }

    public void hSet(String key, Object field, Object value) {
        this.hashOps.put((Object)key, field, value);
    }

    public void hMset(String key, Map<Object, Object> hash) {
        this.hashOps.putAll((Object)key, hash);
    }

    public <T> T hGet(String key, Object field) {
        return (T)this.hashOps.get((Object)key, field);
    }

    public List hmGet(String key, Object ... fields) {
        return this.hmGet(key, Arrays.asList(fields));
    }

    public List hmGet(String key, Collection<Object> hashKeys) {
        return this.hashOps.multiGet((Object)key, hashKeys);
    }

    public Long hDel(String key, Object ... fields) {
        return this.hashOps.delete((Object)key, fields);
    }

    public Boolean hExists(String key, Object field) {
        return this.hashOps.hasKey((Object)key, field);
    }

    public Map hGetAll(String key) {
        return this.hashOps.entries((Object)key);
    }

    public List hVals(String key) {
        return this.hashOps.values((Object)key);
    }

    public Set<Object> hKeys(String key) {
        return this.hashOps.keys((Object)key);
    }

    public Long hLen(String key) {
        return this.hashOps.size((Object)key);
    }

    public Long hIncrBy(String key, Object field, long value) {
        return this.hashOps.increment((Object)key, field, value);
    }

    public Double hIncrByFloat(String key, Object field, double value) {
        return this.hashOps.increment((Object)key, field, value);
    }

    public <T> T lIndex(String key, long index) {
        return (T)this.listOps.index((Object)key, index);
    }

    public Long lLen(String key) {
        return this.listOps.size((Object)key);
    }

    public <T> T lPop(String key) {
        return (T)this.listOps.leftPop((Object)key);
    }

    public Long lPush(String key, Object ... values) {
        return this.listOps.leftPush((Object)key, (Object)values);
    }

    public void lSet(String key, long index, Object value) {
        this.listOps.set((Object)key, index, value);
    }

    public Long lRem(String key, long count, Object value) {
        return this.listOps.remove((Object)key, count, value);
    }

    public List lRange(String key, long start, long end) {
        return this.listOps.range((Object)key, start, end);
    }

    public void lTrim(String key, long start, long end) {
        this.listOps.trim((Object)key, start, end);
    }

    public <T> T rPop(String key) {
        return (T)this.listOps.rightPop((Object)key);
    }

    public Long rPush(String key, Object ... values) {
        return this.listOps.rightPush((Object)key, (Object)values);
    }

    public <T> T rPopLPush(String srcKey, String dstKey) {
        return (T)this.listOps.rightPopAndLeftPush((Object)srcKey, (Object)dstKey);
    }

    public Long sAdd(String key, Object ... members) {
        return this.setOps.add((Object)key, members);
    }

    public <T> T sPop(String key) {
        return (T)this.setOps.pop((Object)key);
    }

    public Set sMembers(String key) {
        return this.setOps.members((Object)key);
    }

    public boolean sIsMember(String key, Object member) {
        return this.setOps.isMember((Object)key, member);
    }

    public Set sInter(String key, String otherKey) {
        return this.setOps.intersect((Object)key, (Object)otherKey);
    }

    public Set sInter(String key, Collection<String> otherKeys) {
        return this.setOps.intersect((Object)key, otherKeys);
    }

    public <T> T sRandMember(String key) {
        return (T)this.setOps.randomMember((Object)key);
    }

    public List sRandMember(String key, int count) {
        return this.setOps.randomMembers((Object)key, (long)count);
    }

    public Long sRem(String key, Object ... members) {
        return this.setOps.remove((Object)key, members);
    }

    public Set sUnion(String key, String otherKey) {
        return this.setOps.union((Object)key, (Object)otherKey);
    }

    public Set sUnion(String key, Collection<String> otherKeys) {
        return this.setOps.union((Object)key, otherKeys);
    }

    public Set sDiff(String key, String otherKey) {
        return this.setOps.difference((Object)key, (Object)otherKey);
    }

    public Set sDiff(String key, Collection<String> otherKeys) {
        return this.setOps.difference((Object)key, otherKeys);
    }

    public Boolean zAdd(String key, Object member, double score) {
        return this.zSetOps.add((Object)key, member, score);
    }

    public Long zAdd(String key, Map<Object, Double> scoreMembers) {
        HashSet tuples = new HashSet();
        scoreMembers.forEach((k, v) -> tuples.add(new DefaultTypedTuple(k, v)));
        return this.zSetOps.add((Object)key, tuples);
    }

    public Long zCard(String key) {
        return this.zSetOps.zCard((Object)key);
    }

    public Long zCount(String key, double min, double max) {
        return this.zSetOps.count((Object)key, min, max);
    }

    public Double zIncrBy(String key, Object member, double score) {
        return this.zSetOps.incrementScore((Object)key, member, score);
    }

    public Set zRange(String key, long start, long end) {
        return this.zSetOps.range((Object)key, start, end);
    }

    public Set zRevrange(String key, long start, long end) {
        return this.zSetOps.reverseRange((Object)key, start, end);
    }

    public Set zRangeByScore(String key, double min, double max) {
        return this.zSetOps.rangeByScore((Object)key, min, max);
    }

    public Long zRank(String key, Object member) {
        return this.zSetOps.rank((Object)key, member);
    }

    public Long zRevrank(String key, Object member) {
        return this.zSetOps.reverseRank((Object)key, member);
    }

    public Long zRem(String key, Object ... members) {
        return this.zSetOps.remove((Object)key, members);
    }

    public Double zScore(String key, Object member) {
        return this.zSetOps.score((Object)key, member);
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public ValueOperations<String, Object> getValueOps() {
        return this.valueOps;
    }

    public HashOperations<String, Object, Object> getHashOps() {
        return this.hashOps;
    }

    public ListOperations<String, Object> getListOps() {
        return this.listOps;
    }

    public SetOperations<String, Object> getSetOps() {
        return this.setOps;
    }

    public ZSetOperations<String, Object> getZSetOps() {
        return this.zSetOps;
    }
}

