/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.redis.ratelimiter;

import com.qqt.platform.redis.ratelimiter.RateLimiter;
import com.qqt.platform.redis.ratelimiter.RedisRateLimiterClient;
import com.qqt.platform.tool.spel.BladeExpressionEvaluator;
import com.qqt.platform.tool.utils.StringUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.expression.EvaluationContext;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

@Aspect
public class RedisRateLimiterAspect
implements ApplicationContextAware {
    private final BladeExpressionEvaluator evaluator = new BladeExpressionEvaluator();
    private final RedisRateLimiterClient rateLimiterClient;
    private ApplicationContext applicationContext;

    @Around(value="@annotation(limiter)")
    public Object aroundRateLimiter(ProceedingJoinPoint point, RateLimiter limiter) throws Throwable {
        String rateKey;
        String limitKey = limiter.value();
        Assert.hasText((String)limitKey, (String)"@RateLimiter value must have length; it must not be null or empty");
        String limitParam = limiter.param();
        if (StringUtil.isNotBlank((CharSequence)limitParam)) {
            String evalAsText = this.evalLimitParam(point, limitParam);
            rateKey = limitKey + ':' + evalAsText;
        } else {
            rateKey = limitKey;
        }
        long max = limiter.max();
        long ttl = limiter.ttl();
        TimeUnit timeUnit = limiter.timeUnit();
        return this.rateLimiterClient.allow(rateKey, max, ttl, timeUnit, () -> ((ProceedingJoinPoint)point).proceed());
    }

    private String evalLimitParam(ProceedingJoinPoint point, String limitParam) {
        MethodSignature ms = (MethodSignature)point.getSignature();
        Method method = ms.getMethod();
        Object[] args = point.getArgs();
        Object target = point.getTarget();
        Class<?> targetClass = target.getClass();
        EvaluationContext context = this.evaluator.createContext(method, args, target, targetClass, (BeanFactory)this.applicationContext);
        AnnotatedElementKey elementKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
        return this.evaluator.evalAsText(limitParam, elementKey, context);
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public RedisRateLimiterAspect(RedisRateLimiterClient rateLimiterClient) {
        this.rateLimiterClient = rateLimiterClient;
    }
}

