/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.redis.serializer;

import com.qqt.platform.redis.serializer.BytesWrapper;
import com.qqt.platform.tool.utils.ObjectUtil;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class ProtoStuffSerializer
implements RedisSerializer<Object> {
    private final Schema<BytesWrapper> schema = RuntimeSchema.getSchema(BytesWrapper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(Object object) throws SerializationException {
        if (object == null) {
            return null;
        }
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            byte[] byArray = ProtostuffIOUtil.toByteArray(new BytesWrapper<Object>(object), this.schema, (LinkedBuffer)buffer);
            return byArray;
        }
        finally {
            buffer.clear();
        }
    }

    public Object deserialize(byte[] bytes) throws SerializationException {
        if (ObjectUtil.isEmpty((Object)bytes)) {
            return null;
        }
        BytesWrapper wrapper = new BytesWrapper();
        ProtostuffIOUtil.mergeFrom((byte[])bytes, wrapper, this.schema);
        return wrapper.getValue();
    }
}

