/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.sourcepool.dl.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.api.request.dl.ReqDlGetProductStockDO;
import com.qqt.pool.api.response.dl.DlGetProductStockRespDO;
import com.qqt.pool.api.thirdPlatform.request.CommonProductSkuInfoDO;
import com.qqt.pool.api.thirdPlatform.request.CommonStockCheckDO;
import com.qqt.pool.api.thirdPlatform.response.CommonRetInventoryInfoRespDO;
import com.qqt.pool.base.response.PoolRespBean;
import com.qqt.pool.common.dto.ResultDTO;
import com.qqt.pool.common.exception.BusinessException;
import com.qqt.pool.common.service.PoolsService;
import com.qqt.pool.common.utils.ThreadLocalUtil;
import com.qqt.sourcepool.dl.feign.SourcePoolDLFeignService;
import com.qqt.sourcepool.dl.strategy.mapper.DlProductStockDOMapper;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="90003_dl")
public class DlGetProductStockServiceImpl
implements PoolsService {
    @Autowired
    private SourcePoolDLFeignService feignService;
    @Autowired
    private DlProductStockDOMapper doMapper;

    public String service(String content) {
        String type;
        switch (type = (String)ThreadLocalUtil.get((String)"mode")) {
            case "DEFAULT_MODE": {
                ReqDlGetProductStockDO getProductStockDO = (ReqDlGetProductStockDO)JSON.parseObject((String)content, ReqDlGetProductStockDO.class);
                ResultDTO<DlGetProductStockRespDO> resultDTO = this.feignService.getProductStock(getProductStockDO);
                if (resultDTO.isFail()) {
                    return JSON.toJSONString((Object)PoolRespBean.fail((String)resultDTO.getMsg()));
                }
                return JSON.toJSONString((Object)resultDTO.getData());
            }
            case "FAST_MODE": {
                CommonStockCheckDO req = (CommonStockCheckDO)JSON.parseObject((String)content, CommonStockCheckDO.class);
                ReqDlGetProductStockDO getProductStock = new ReqDlGetProductStockDO();
                getProductStock.setSku(req.getProductSkuList().stream().map(CommonProductSkuInfoDO::getSkuCode).collect(Collectors.joining(",")));
                ResultDTO<DlGetProductStockRespDO> result = this.feignService.getProductStock(getProductStock);
                if (result.isFail()) {
                    return JSON.toJSONString((Object)new CommonRetInventoryInfoRespDO());
                }
                CommonRetInventoryInfoRespDO commonRetInventoryInfoRespDO = this.doMapper.toCommonDO((DlGetProductStockRespDO)result.getData());
                return JSON.toJSONString((Object)commonRetInventoryInfoRespDO);
            }
        }
        throw new BusinessException("Does not support this mode of execution", "\u4e0d\u652f\u6301\u8be5\u6a21\u5f0f\u6267\u884c");
    }
}

