/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.sourcepool.dl.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.api.request.dl.ReqDlOrderSubmitDO;
import com.qqt.pool.api.response.dl.DLOrderReturnInfoRespDO;
import com.qqt.pool.api.thirdPlatform.request.CommonOrderSubmitDO;
import com.qqt.pool.api.thirdPlatform.response.CommonOrderReturnInfoRespDO;
import com.qqt.pool.base.response.PoolRespBean;
import com.qqt.pool.common.dto.ResultDTO;
import com.qqt.pool.common.exception.BusinessException;
import com.qqt.pool.common.service.PoolsService;
import com.qqt.pool.common.utils.ThreadLocalUtil;
import com.qqt.sourcepool.dl.feign.SourcePoolDLFeignService;
import com.qqt.sourcepool.dl.strategy.mapper.DlOrderSubmitDOMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="90001_dl")
public class DlOrderSubmitServiceImpl
implements PoolsService {
    @Autowired
    private SourcePoolDLFeignService feignService;
    @Autowired
    private DlOrderSubmitDOMapper orderSubmitDOMapper;

    public String service(String content) {
        String type;
        switch (type = (String)ThreadLocalUtil.get((String)"mode")) {
            case "DEFAULT_MODE": {
                ReqDlOrderSubmitDO orderSubmitDO = (ReqDlOrderSubmitDO)JSON.parseObject((String)content, ReqDlOrderSubmitDO.class);
                ResultDTO<DLOrderReturnInfoRespDO> entity = this.feignService.submitOrder(orderSubmitDO);
                if (entity.isFail()) {
                    return JSON.toJSONString((Object)PoolRespBean.fail((String)entity.getMsg()));
                }
                return JSON.toJSONString((Object)entity.getData());
            }
            case "FAST_MODE": {
                CommonOrderSubmitDO commonOrderSubmitDO = (CommonOrderSubmitDO)JSON.parseObject((String)content, CommonOrderSubmitDO.class);
                ReqDlOrderSubmitDO submitOrderDO = this.orderSubmitDOMapper.toDO(commonOrderSubmitDO);
                ResultDTO<DLOrderReturnInfoRespDO> entity = this.feignService.submitOrder(submitOrderDO);
                if (entity.isFail()) {
                    return JSON.toJSONString((Object)PoolRespBean.fail((String)entity.getMsg()));
                }
                DLOrderReturnInfoRespDO data = (DLOrderReturnInfoRespDO)entity.getData();
                CommonOrderReturnInfoRespDO commonOrderReturnInfoRespDO = this.orderSubmitDOMapper.toCommonDO(data);
                commonOrderReturnInfoRespDO.setCompanyName(commonOrderSubmitDO.getInvoiceInfoDO().getTitle());
                commonOrderReturnInfoRespDO.setAddress(commonOrderSubmitDO.getCommonRegionInfoSubDO().getAddressLine());
                commonOrderReturnInfoRespDO.setThirdOrder(commonOrderSubmitDO.getThirdOrder());
                return JSON.toJSONString((Object)commonOrderReturnInfoRespDO);
            }
        }
        throw new BusinessException("Does not support this mode of execution", "\u4e0d\u652f\u6301\u8be5\u6a21\u5f0f\u6267\u884c");
    }
}

