/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.sourcepool.dl.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.api.request.dl.ReqDlOrderTrackDO;
import com.qqt.pool.api.response.dl.DlOrderTarckRespDO;
import com.qqt.pool.api.thirdPlatform.request.CommonReqOrderTrackDO;
import com.qqt.pool.api.thirdPlatform.response.CommonOrderTrackRespDO;
import com.qqt.pool.api.thirdPlatform.response.sub.CommonDeliveryItemsDO;
import com.qqt.pool.api.thirdPlatform.response.sub.CommonOrderTrackDO;
import com.qqt.pool.base.response.PoolRespBean;
import com.qqt.pool.common.dto.ResultDTO;
import com.qqt.pool.common.exception.BusinessException;
import com.qqt.pool.common.service.PoolsService;
import com.qqt.pool.common.utils.ThreadLocalUtil;
import com.qqt.sourcepool.dl.feign.SourcePoolDLFeignService;
import com.qqt.sourcepool.dl.strategy.mapper.DlOrderTrackDOMapper;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="90017_dl")
public class DlOrderTrackServiceImpl
implements PoolsService {
    @Autowired
    private SourcePoolDLFeignService feignService;
    @Autowired
    private DlOrderTrackDOMapper mapper;

    public String service(String content) {
        String type;
        switch (type = (String)ThreadLocalUtil.get((String)"mode")) {
            case "DEFAULT_MODE": {
                ReqDlOrderTrackDO reqSnSubmitOrderDO = (ReqDlOrderTrackDO)JSON.parseObject((String)content, ReqDlOrderTrackDO.class);
                ResultDTO<DlOrderTarckRespDO> entity = this.feignService.getOrderTrack(reqSnSubmitOrderDO);
                if (entity.isFail()) {
                    return JSON.toJSONString((Object)PoolRespBean.fail((String)entity.getMsg()));
                }
                String deliveryCode = ((DlOrderTarckRespDO)entity.getData()).getDeliveryCode();
                if (!StringUtils.isEmpty((Object)deliveryCode)) {
                    // empty if block
                }
                return JSON.toJSONString((Object)entity.getData());
            }
            case "FAST_MODE": {
                CommonReqOrderTrackDO reqDO = (CommonReqOrderTrackDO)JSON.parseObject((String)content, CommonReqOrderTrackDO.class);
                ReqDlOrderTrackDO reqSnSubmitOrderDO1 = new ReqDlOrderTrackDO();
                reqSnSubmitOrderDO1.setPackageId(reqDO.getPackageId());
                reqSnSubmitOrderDO1.setOrderId(reqDO.getThirdOrderId());
                ResultDTO<DlOrderTarckRespDO> entity = this.feignService.getOrderTrack(reqSnSubmitOrderDO1);
                if (entity.isFail()) {
                    return JSON.toJSONString((Object)PoolRespBean.fail((String)entity.getMsg()));
                }
                DlOrderTarckRespDO data = (DlOrderTarckRespDO)entity.getData();
                CommonOrderTrackRespDO trackRespDO = new CommonOrderTrackRespDO();
                if (data != null) {
                    List logisticsDetailDOS;
                    List deliveryItemsDOs = data.getDeliveryItemsDOs();
                    if (!CollectionUtils.isEmpty((Collection)deliveryItemsDOs)) {
                        List<CommonDeliveryItemsDO> itemsDOS = this.mapper.toItemDO(deliveryItemsDOs);
                        trackRespDO.setDeliveryItemsDOS(itemsDOS);
                    }
                    if (!CollectionUtils.isEmpty((Collection)(logisticsDetailDOS = data.getLogisticsDetailDOS()))) {
                        List<CommonOrderTrackDO> commonOrderTrackDOS = this.mapper.toDO(logisticsDetailDOS);
                        commonOrderTrackDOS.forEach(o -> {
                            o.setDeliveryName(data.getDeliveryName());
                            o.setExpressNo(data.getDeliveryCode());
                        });
                        trackRespDO.setOrderTrack(commonOrderTrackDOS);
                        trackRespDO.setPackageId(reqDO.getPackageId());
                    }
                }
                return JSON.toJSONString((Object)trackRespDO);
            }
        }
        throw new BusinessException("Does not support this mode of execution", "\u4e0d\u652f\u6301\u8be5\u6a21\u5f0f\u6267\u884c");
    }
}

