/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.sourcepool.dl.strategy.mapper;

import com.qqt.pool.api.request.dl.ReqDlOrderSubmitDO;
import com.qqt.pool.api.request.dl.sub.ReqDlOrderSkuDO;
import com.qqt.pool.api.response.dl.DLOrderReturnInfoRespDO;
import com.qqt.pool.api.thirdPlatform.request.CommonOrderSubmitDO;
import com.qqt.pool.api.thirdPlatform.request.CommonProductSkuInfoDO;
import com.qqt.pool.api.thirdPlatform.request.sub.CommonOrderInvoiceInfoSubDO;
import com.qqt.pool.api.thirdPlatform.request.sub.CommonRegionInfoSubDO;
import com.qqt.pool.api.thirdPlatform.response.CommonOrderReturnInfoRespDO;
import com.qqt.pool.api.thirdPlatform.response.CommonOrderReturnSkuInfoDO;
import com.qqt.pool.common.exception.BusinessException;
import com.qqt.pool.common.utils.UserUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;

@Mapper(componentModel="spring", uses={})
public abstract class DlOrderSubmitDOMapper {
    public abstract ReqDlOrderSubmitDO toDO(CommonOrderSubmitDO var1);

    public abstract CommonOrderReturnInfoRespDO toCommonDO(DLOrderReturnInfoRespDO var1);

    @AfterMapping
    protected void afterMapping(CommonOrderSubmitDO toDO, @MappingTarget ReqDlOrderSubmitDO reqDO) {
        CommonRegionInfoSubDO commonRegionInfoDO;
        reqDO.setPxOrderId(toDO.getThirdOrder());
        reqDO.setOrderCompany(toDO.getInvoiceInfoDO().getTitle());
        reqDO.setMobile(toDO.getMobile());
        reqDO.setName(toDO.getReceiverName());
        reqDO.setThirdOrder(toDO.getThirdOrder());
        reqDO.setEmail(toDO.getMail());
        reqDO.setZip("000000");
        reqDO.setRemark(toDO.getMemo());
        reqDO.setPayType(Integer.valueOf(1));
        reqDO.setOrderStatus(Integer.valueOf(1));
        CommonOrderInvoiceInfoSubDO invoice = toDO.getInvoiceInfoDO();
        if (Objects.nonNull(invoice)) {
            reqDO.setInvoiceType(Integer.valueOf(2));
            reqDO.setInvoiceState(Integer.valueOf(2));
            reqDO.setInvoiceTitleType(Integer.valueOf(2));
            reqDO.setInvoiceTitle(invoice.getTitle());
            reqDO.setInvoiceIdNo(invoice.getEnterpriseTaxpayer());
            reqDO.setInvoiceTelephone(invoice.getTel());
            reqDO.setInvoiceBankName(invoice.getBank());
            reqDO.setInvoiceBankNo(invoice.getAccount());
            reqDO.setInvoiceAddress(invoice.getAddress().replace("\\", "").replace(" ", ""));
            reqDO.setCompanyName(UserUtils.getSessionService().getCurrentCompanyName());
            reqDO.setInvoiceContent(invoice.getContent());
        }
        if (Objects.isNull(commonRegionInfoDO = toDO.getCommonRegionInfoSubDO())) {
            throw new BusinessException("no match address", "\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqDO.setProvince(Integer.valueOf(Integer.parseInt(commonRegionInfoDO.getProvinceCode())));
        reqDO.setCounty(Integer.valueOf(Integer.parseInt(commonRegionInfoDO.getCountyCode())));
        reqDO.setCity(Integer.valueOf(Integer.parseInt(commonRegionInfoDO.getCityCode())));
        reqDO.setAddress(commonRegionInfoDO.getAddressLine().replace("\\", "").replace(" ", ""));
        ArrayList<ReqDlOrderSkuDO> skus = new ArrayList<ReqDlOrderSkuDO>();
        List list = toDO.getProductSkuList();
        for (CommonProductSkuInfoDO o : list) {
            ReqDlOrderSkuDO dto = new ReqDlOrderSkuDO();
            dto.setNum(Integer.valueOf(Integer.parseInt(o.getQuantity() + "")));
            dto.setPrice(Double.valueOf(o.getUnitPrice().doubleValue()));
            dto.setPxSku(o.getSkuCode());
            dto.setSku(o.getSkuCode());
            skus.add(dto);
        }
        reqDO.setOrderDetails(skus);
    }

    @AfterMapping
    protected void afterMapping(DLOrderReturnInfoRespDO toDO, @MappingTarget CommonOrderReturnInfoRespDO commonDO) {
        commonDO.setOrderPrice(toDO.getOrderPrice());
        commonDO.setOrderId(toDO.getPxOrderId());
        List skuDOList = toDO.getSkuDOList();
        ArrayList<CommonOrderReturnSkuInfoDO> skus = new ArrayList<CommonOrderReturnSkuInfoDO>();
        Double totalTax = 0.0;
        Double totalNakeTax = 0.0;
        for (ReqDlOrderSkuDO o : skuDOList) {
            CommonOrderReturnSkuInfoDO dto = new CommonOrderReturnSkuInfoDO();
            dto.setNakedPrice(new BigDecimal(String.valueOf(o.getNakedPrice())));
            dto.setNum(o.getNum());
            dto.setSkuId(o.getPxSku());
            dto.setPrice(new BigDecimal(String.valueOf(o.getPrice())));
            dto.setTax(Double.valueOf(Double.parseDouble(o.getTaxRate() + "")));
            dto.setThirdSkuId(o.getSku());
            dto.setThirdSkuName(o.getName());
            dto.setName(o.getName());
            totalTax = o.getTaxRate() + totalTax;
            totalNakeTax = o.getNakedPrice() + totalNakeTax;
            skus.add(dto);
        }
        commonDO.setOrderTaxPrice(totalTax);
        commonDO.setOrderNakedPrice(totalNakeTax);
        commonDO.setSku(skus);
    }
}

