/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.base.utils;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    private static RequestConfig requestConfig = null;
    private static ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy = null;
    private static PoolingHttpClientConnectionManager cm = null;
    private static HttpRequestRetryHandler httpRequestRetryHandler = null;

    private HttpClientUtil() {
    }

    public static CloseableHttpClient createSSLClientDefault(Boolean bool) {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            if (bool.booleanValue()) {
                return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setRetryHandler(httpRequestRetryHandler).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManagerShared(true).build();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setRetryHandler(httpRequestRetryHandler).setConnectionManagerShared(true).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> param) {
        CloseableHttpClient httpclient = HttpClientUtil.createSSLClientDefault(null != url && "".equals(url) && url.startsWith("https"));
        String resultString = "";
        CloseableHttpResponse response = null;
        try {
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            URI uri = builder.build();
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setConfig(requestConfig);
            response = httpclient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    public static String doGet(String url) {
        return HttpClientUtil.doGet(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, Object> param) {
        CloseableHttpClient httpClient = HttpClientUtil.createSSLClientDefault(null != url && "".equals(url) && url.startsWith("https"));
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            if (param != null) {
                ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
                for (String key : param.keySet()) {
                    paramList.add(new BasicNameValuePair(key, (String)param.get(key)));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList);
                httpPost.setEntity((HttpEntity)entity);
            }
            httpPost.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    public static String doPost(String url) {
        return HttpClientUtil.doPost(url, null);
    }

    public static String doPostJson(String url, Map<String, String> headParams, String json, String token_header) throws Exception {
        CloseableHttpClient httpClient = HttpClientUtil.createSSLClientDefault(null != url && "".equals(url) && url.startsWith("https"));
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("HTTP Method", "POST");
            httpPost.setHeader("Connection", "Keep-Alive");
            httpPost.setHeader("Content-Type", "application/json;charset=utf-8");
            httpPost.setHeader("sign", headParams.get("sign"));
            StringEntity entity = new StringEntity(json, Charset.forName("UTF-8"));
            entity.setContentEncoding("utf-8");
            entity.setContentType("application/json;charset=utf-8");
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() == 200) {
                resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    static {
        requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectionRequestTimeout(60000).setConnectionRequestTimeout(60000).build();
        httpRequestRetryHandler = (exception, retryTimes, context) -> {
            boolean idempotent;
            log.info("retryTimes:{}", (Object)retryTimes);
            if (retryTimes >= 3) {
                return false;
            }
            if (exception instanceof ConnectTimeoutException || exception instanceof NoHttpResponseException || exception instanceof SocketTimeoutException || !(exception instanceof UnknownHostException) || !(exception instanceof InterruptedIOException) || !(exception instanceof SSLException) || !(exception instanceof SSLHandshakeException)) {
                return true;
            }
            log.info("\u672a\u8bb0\u5f55\u7684\u5f02\u5e38{}", exception.getClass());
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            HttpRequest request = clientContext.getRequest();
            boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
            return idempotent;
        };
        serviceUnavailableRetryStrategy = new ServiceUnavailableRetryStrategy(){

            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                log.info("retryRequest:{}", (Object)executionCount);
                return executionCount <= 3;
            }

            public long getRetryInterval() {
                log.info("getRetryInterval");
                return 5000L;
            }
        };
        cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(100);
    }
}

