/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.aop;

import com.qqt.pool.common.dto.LogUsualDTO;
import com.qqt.pool.common.event.UsualLogPublisher;
import com.qqt.pool.common.service.SessionService;
import com.qqt.pool.common.utils.WebUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class UsualLogger
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(UsualLogger.class);
    @Value(value="${spring.application.name}")
    private String serviceId;
    @Value(value="${saveLog.usual.level:info}")
    private String level;
    @Autowired
    private SessionService sessionService;

    private void doLog(Level level, String template, Object ... arguments) {
        LogUsualDTO logUsual = new LogUsualDTO();
        logUsual.setLogLevel(level.name());
        logUsual.setLogId(Thread.currentThread().getName());
        String message = MessageFormatter.arrayFormat((String)template, (Object[])arguments).getMessage();
        logUsual.setLogData(message);
        HttpServletRequest request = WebUtil.getRequest();
        String token = request.getHeader("Authorization");
        Long userId = (Long)this.sessionService.getInfo(token, "userId");
        Long companyId = (Long)this.sessionService.getInfo(token, "companyId");
        String siteCode = (String)this.sessionService.getInfo(token, "siteCode");
        String login = (String)this.sessionService.getInfo(token, "userCode");
        String elsAccount = (String)this.sessionService.getInfo(token, "elsAccount");
        String companyName = (String)this.sessionService.getInfo(token, "companyName");
        logUsual.setUserId(userId);
        logUsual.setCompanyName(companyName);
        logUsual.setLogin(login);
        logUsual.setElsAccount(elsAccount);
        logUsual.setSiteCode(siteCode);
        logUsual.setCompanyId(companyId);
        UsualLogPublisher.publishEvent(logUsual);
    }

    public void info(String template, Object arg) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.INFO)) {
            this.doLog(logLevel, template, arg);
        }
    }

    public void info(String template, Object arg1, Object arg2) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.INFO)) {
            this.doLog(logLevel, template, arg1, arg2);
        }
    }

    public void info(String template, Object ... arguments) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.INFO)) {
            this.doLog(logLevel, template, arguments);
        }
    }

    public void debug(String template, Object arg) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.DEBUG)) {
            this.doLog(logLevel, template, arg);
        }
    }

    public void debug(String template, Object arg1, Object arg2) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.DEBUG)) {
            this.doLog(logLevel, template, arg1, arg2);
        }
    }

    public void debug(String template, Object ... arguments) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.DEBUG)) {
            this.doLog(logLevel, template, arguments);
        }
    }

    public void warn(String template, Object arg) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.WARN)) {
            this.doLog(logLevel, template, arg);
        }
    }

    public void warn(String template, Object arg1, Object arg2) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.WARN)) {
            this.doLog(logLevel, template, arg1, arg2);
        }
    }

    public void warn(String template, Object ... arguments) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.WARN)) {
            this.doLog(logLevel, template, arguments);
        }
    }

    public void error(String template, Object arg) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.ERROR)) {
            this.doLog(logLevel, template, arg);
        }
    }

    public void error(String template, Object arg1, Object arg2) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.ERROR)) {
            this.doLog(logLevel, template, arg1, arg2);
        }
    }

    public void error(String template, Object ... arguments) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.ERROR)) {
            this.doLog(logLevel, template, arguments);
        }
    }

    public void trace(String template, Object arg) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.TRACE)) {
            this.doLog(logLevel, template, arg);
        }
    }

    public void trace(String template, Object arg1, Object arg2) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.TRACE)) {
            this.doLog(logLevel, template, arg1, arg2);
        }
    }

    public void trace(String template, Object ... arguments) {
        Level logLevel = Level.valueOf((String)this.level.toUpperCase());
        if (logLevel.equals((Object)Level.TRACE)) {
            this.doLog(logLevel, template, arguments);
        }
    }

    public void afterPropertiesSet() {
        log.info("{}: UsualLogger init success!", (Object)this.serviceId);
    }
}

