/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.config;

import java.util.Arrays;
import okhttp3.TlsVersion;

public class HttpClientConfig {
    private String url;
    private String username;
    private String password;
    private String oauthToken;
    private int connectionTimeout = 60000;
    private int requestTimeout = 60000;
    private int webSocketPingInterval;
    private int maxConcurrentRequestsPerHost = 30;
    private int maxConnection = 40;
    private String httpProxy;
    private String httpsProxy;
    private String proxyUsername;
    private String proxyPassword;
    private String userAgent;
    private TlsVersion[] tlsVersions = new TlsVersion[]{TlsVersion.TLS_1_2};
    private String[] noProxy;
    public static final String HTTP_PROTOCOL_PREFIX = "http://";
    public static final String HTTPS_PROTOCOL_PREFIX = "https://";

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getOauthToken() {
        return this.oauthToken;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public int getWebSocketPingInterval() {
        return this.webSocketPingInterval;
    }

    public int getMaxConcurrentRequestsPerHost() {
        return this.maxConcurrentRequestsPerHost;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    public String getHttpsProxy() {
        return this.httpsProxy;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public TlsVersion[] getTlsVersions() {
        return this.tlsVersions;
    }

    public String[] getNoProxy() {
        return this.noProxy;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setWebSocketPingInterval(int webSocketPingInterval) {
        this.webSocketPingInterval = webSocketPingInterval;
    }

    public void setMaxConcurrentRequestsPerHost(int maxConcurrentRequestsPerHost) {
        this.maxConcurrentRequestsPerHost = maxConcurrentRequestsPerHost;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    public void setHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
    }

    public void setHttpsProxy(String httpsProxy) {
        this.httpsProxy = httpsProxy;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setTlsVersions(TlsVersion[] tlsVersions) {
        this.tlsVersions = tlsVersions;
    }

    public void setNoProxy(String[] noProxy) {
        this.noProxy = noProxy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpClientConfig)) {
            return false;
        }
        HttpClientConfig other = (HttpClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$oauthToken = this.getOauthToken();
        String other$oauthToken = other.getOauthToken();
        if (this$oauthToken == null ? other$oauthToken != null : !this$oauthToken.equals(other$oauthToken)) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        if (this.getRequestTimeout() != other.getRequestTimeout()) {
            return false;
        }
        if (this.getWebSocketPingInterval() != other.getWebSocketPingInterval()) {
            return false;
        }
        if (this.getMaxConcurrentRequestsPerHost() != other.getMaxConcurrentRequestsPerHost()) {
            return false;
        }
        if (this.getMaxConnection() != other.getMaxConnection()) {
            return false;
        }
        String this$httpProxy = this.getHttpProxy();
        String other$httpProxy = other.getHttpProxy();
        if (this$httpProxy == null ? other$httpProxy != null : !this$httpProxy.equals(other$httpProxy)) {
            return false;
        }
        String this$httpsProxy = this.getHttpsProxy();
        String other$httpsProxy = other.getHttpsProxy();
        if (this$httpsProxy == null ? other$httpsProxy != null : !this$httpsProxy.equals(other$httpsProxy)) {
            return false;
        }
        String this$proxyUsername = this.getProxyUsername();
        String other$proxyUsername = other.getProxyUsername();
        if (this$proxyUsername == null ? other$proxyUsername != null : !this$proxyUsername.equals(other$proxyUsername)) {
            return false;
        }
        String this$proxyPassword = this.getProxyPassword();
        String other$proxyPassword = other.getProxyPassword();
        if (this$proxyPassword == null ? other$proxyPassword != null : !this$proxyPassword.equals(other$proxyPassword)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTlsVersions(), other.getTlsVersions())) {
            return false;
        }
        return Arrays.deepEquals(this.getNoProxy(), other.getNoProxy());
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $oauthToken = this.getOauthToken();
        result = result * 59 + ($oauthToken == null ? 43 : $oauthToken.hashCode());
        result = result * 59 + this.getConnectionTimeout();
        result = result * 59 + this.getRequestTimeout();
        result = result * 59 + this.getWebSocketPingInterval();
        result = result * 59 + this.getMaxConcurrentRequestsPerHost();
        result = result * 59 + this.getMaxConnection();
        String $httpProxy = this.getHttpProxy();
        result = result * 59 + ($httpProxy == null ? 43 : $httpProxy.hashCode());
        String $httpsProxy = this.getHttpsProxy();
        result = result * 59 + ($httpsProxy == null ? 43 : $httpsProxy.hashCode());
        String $proxyUsername = this.getProxyUsername();
        result = result * 59 + ($proxyUsername == null ? 43 : $proxyUsername.hashCode());
        String $proxyPassword = this.getProxyPassword();
        result = result * 59 + ($proxyPassword == null ? 43 : $proxyPassword.hashCode());
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTlsVersions());
        result = result * 59 + Arrays.deepHashCode(this.getNoProxy());
        return result;
    }

    public String toString() {
        return "HttpClientConfig(url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", oauthToken=" + this.getOauthToken() + ", connectionTimeout=" + this.getConnectionTimeout() + ", requestTimeout=" + this.getRequestTimeout() + ", webSocketPingInterval=" + this.getWebSocketPingInterval() + ", maxConcurrentRequestsPerHost=" + this.getMaxConcurrentRequestsPerHost() + ", maxConnection=" + this.getMaxConnection() + ", httpProxy=" + this.getHttpProxy() + ", httpsProxy=" + this.getHttpsProxy() + ", proxyUsername=" + this.getProxyUsername() + ", proxyPassword=" + this.getProxyPassword() + ", userAgent=" + this.getUserAgent() + ", tlsVersions=" + Arrays.deepToString(this.getTlsVersions()) + ", noProxy=" + Arrays.deepToString(this.getNoProxy()) + ")";
    }

    public HttpClientConfig() {
    }

    public HttpClientConfig(String url, String username, String password, String oauthToken, int connectionTimeout, int requestTimeout, int webSocketPingInterval, int maxConcurrentRequestsPerHost, int maxConnection, String httpProxy, String httpsProxy, String proxyUsername, String proxyPassword, String userAgent, TlsVersion[] tlsVersions, String[] noProxy) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.oauthToken = oauthToken;
        this.connectionTimeout = connectionTimeout;
        this.requestTimeout = requestTimeout;
        this.webSocketPingInterval = webSocketPingInterval;
        this.maxConcurrentRequestsPerHost = maxConcurrentRequestsPerHost;
        this.maxConnection = maxConnection;
        this.httpProxy = httpProxy;
        this.httpsProxy = httpsProxy;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.userAgent = userAgent;
        this.tlsVersions = tlsVersions;
        this.noProxy = noProxy;
    }
}

