/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WeChatBotUtils {
    private static Logger log = LoggerFactory.getLogger(WeChatBotUtils.class);
    private static String environment;
    private static String server;
    private static String key;
    private static String botUrl;
    private static int maxTextLen;

    @Value(value="${spring.profiles.active}")
    public void setEnvironment(String env) {
        environment = env;
    }

    @Value(value="${spring.application.name}")
    public void setServer(String server) {
    }

    @Value(value="${wechat.bot.key:55f6199f-e026-4f28-ab28-1f4fe26b7dbc}")
    public void setKey(String key) {
        WeChatBotUtils.key = key;
    }

    public static String sendTextMsg(String msg) {
        String respMsg = "";
        JSONObject text = new JSONObject();
        if (msg.length() > maxTextLen) {
            msg = msg.substring(0, maxTextLen);
        }
        msg = String.format("%s\u73af\u5883\uff1a%s\u670d\u52a1\u63a5\u53e3\u53d1\u9001\u544a\u8b66\u5f02\u5e38: %s", environment, server, msg);
        text.put("content", (Object)msg);
        JSONObject reqBody = new JSONObject();
        reqBody.put("msgtype", (Object)"text");
        reqBody.put("text", (Object)text);
        reqBody.put("safe", (Object)0);
        try {
            respMsg = WeChatBotUtils.callWeChatBot(reqBody.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            WeChatBotUtils.sendTextMsg("\u7fa4\u673a\u5668\u4eba\u63a8\u9001\u6d88\u606f\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a\n" + respMsg);
        }
        return respMsg;
    }

    public static String sendImgMsg(String path) throws Exception {
        FileInputStream inputStream;
        String base64 = "";
        String md5 = "";
        try {
            inputStream = new FileInputStream(path);
            byte[] bs = new byte[inputStream.available()];
            inputStream.read(bs);
            base64 = Base64.getEncoder().encodeToString(bs);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            inputStream = new FileInputStream(path);
            byte[] buf = new byte[inputStream.available()];
            inputStream.read(buf);
            md5 = DigestUtils.md5Hex((byte[])buf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject image = new JSONObject();
        image.put("base64", (Object)base64);
        image.put("md5", (Object)md5);
        JSONObject reqBody = new JSONObject();
        reqBody.put("msgtype", (Object)"image");
        reqBody.put("image", (Object)image);
        reqBody.put("safe", (Object)0);
        return WeChatBotUtils.callWeChatBot(reqBody.toString());
    }

    public static String sendMarKDownMsg(String msg) throws Exception {
        JSONObject markdown = new JSONObject();
        markdown.put("content", (Object)msg);
        JSONObject reqBody = new JSONObject();
        reqBody.put("msgtype", (Object)"markdown");
        reqBody.put("markdown", (Object)markdown);
        reqBody.put("safe", (Object)0);
        return WeChatBotUtils.callWeChatBot(reqBody.toString());
    }

    public static String sendFileMsg(String path) throws Exception {
        File file = new File(path);
        MediaType contentType = MediaType.parse((String)"application/form-data; boundary");
        RequestBody body = RequestBody.create((MediaType)contentType, (File)file);
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), body).build();
        String mediaUrl = "https://qyapi.weixin.qq.com/cgi-bin/webhook/upload_media?type=file&" + key;
        log.info("\u5c06\u6587\u4ef6" + path + "\u4e0a\u4f20\u5230\u4e34\u65f6\u7d20\u6750\uff1a" + mediaUrl);
        String respMsg = WeChatBotUtils.okHttp((RequestBody)requestBody, mediaUrl);
        JSONObject result = JSONObject.parseObject((String)respMsg);
        String media_id = result.getString("media_id");
        JSONObject fileJson = new JSONObject();
        fileJson.put("media_id", (Object)media_id);
        JSONObject reqBody = new JSONObject();
        reqBody.put("msgtype", (Object)"file");
        reqBody.put("file", (Object)fileJson);
        reqBody.put("safe", (Object)0);
        return WeChatBotUtils.callWeChatBot(reqBody.toString());
    }

    public static String callWeChatBot(String reqBody) throws Exception {
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + reqBody);
        MediaType contentType = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)contentType, (String)reqBody);
        String url = botUrl + key;
        String respMsg = WeChatBotUtils.okHttp(body, url);
        if ("0".equals(respMsg.substring(11, 12))) {
            log.info("\u5411\u7fa4\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01");
        } else {
            log.info("\u8bf7\u6c42\u5931\u8d25\uff01");
        }
        return respMsg;
    }

    public static String okHttp(RequestBody body, String url) throws Exception {
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).build();
        Request request = new Request.Builder().url(url).post(body).addHeader("cache-control", "no-cache").build();
        Response response = null;
        try {
            response = client.newCall(request).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] datas = response.body().bytes();
        String respMsg = new String(datas);
        log.info("\u8fd4\u56de\u7ed3\u679c\uff1a" + respMsg);
        return respMsg;
    }

    static {
        botUrl = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=";
        maxTextLen = 4000;
    }
}

