/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.impl;

import com.google.common.collect.Maps;
import com.querydsl.core.JoinType;
import com.querydsl.core.dml.UpdateClause;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPAQueryMixin;
import com.querydsl.jpa.JPQLSerializer;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.impl.JPAProvider;
import com.querydsl.jpa.impl.JPAUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;

public class JPAUpdateClause
implements UpdateClause<JPAUpdateClause> {
    private final QueryMixin<?> queryMixin = new JPAQueryMixin();
    private final Map<Path<?>, Expression<?>> updates = Maps.newLinkedHashMap();
    private final EntityManager entityManager;
    private final JPQLTemplates templates;
    @Nullable
    private LockModeType lockMode;

    public JPAUpdateClause(EntityManager em, EntityPath<?> entity) {
        this(em, entity, JPAProvider.getTemplates(em));
    }

    public JPAUpdateClause(EntityManager em, EntityPath<?> entity, JPQLTemplates templates) {
        this.entityManager = em;
        this.templates = templates;
        this.queryMixin.addJoin(JoinType.DEFAULT, entity);
    }

    public long execute() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, this.entityManager);
        serializer.serializeForUpdate(this.queryMixin.getMetadata(), this.updates);
        Map constants = serializer.getConstantToLabel();
        Query query = this.entityManager.createQuery(serializer.toString());
        if (this.lockMode != null) {
            query.setLockMode(this.lockMode);
        }
        JPAUtil.setConstants(query, constants, this.queryMixin.getMetadata().getParams());
        return query.executeUpdate();
    }

    public <T> JPAUpdateClause set(Path<T> path, T value) {
        if (value != null) {
            this.updates.put(path, Expressions.constant(value));
        } else {
            this.setNull(path);
        }
        return this;
    }

    public <T> JPAUpdateClause set(Path<T> path, Expression<? extends T> expression) {
        if (expression != null) {
            this.updates.put(path, expression);
        } else {
            this.setNull(path);
        }
        return this;
    }

    public <T> JPAUpdateClause setNull(Path<T> path) {
        this.updates.put(path, (Expression<?>)Expressions.nullExpression(path));
        return this;
    }

    public JPAUpdateClause set(List<? extends Path<?>> paths, List<?> values) {
        for (int i = 0; i < paths.size(); ++i) {
            if (values.get(i) != null) {
                this.updates.put(paths.get(i), Expressions.constant(values.get(i)));
                continue;
            }
            this.updates.put(paths.get(i), (Expression<?>)Expressions.nullExpression(paths.get(i)));
        }
        return this;
    }

    public JPAUpdateClause where(Predicate ... o) {
        for (Predicate p : o) {
            this.queryMixin.where(p);
        }
        return this;
    }

    public JPAUpdateClause setLockMode(LockModeType lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    public String toString() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, this.entityManager);
        serializer.serializeForUpdate(this.queryMixin.getMetadata(), this.updates);
        return serializer.toString();
    }

    public boolean isEmpty() {
        return this.updates.isEmpty();
    }
}

