/*
 * Decompiled with CFR 0.152.
 */
package com.redis.testcontainers;

import com.redis.enterprise.Admin;
import com.redis.enterprise.Database;
import com.redis.enterprise.RedisModule;
import com.redis.testcontainers.AbstractRedisEnterpriseContainer;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.utility.DockerImageName;

public class RedisEnterpriseContainer
extends AbstractRedisEnterpriseContainer<RedisEnterpriseContainer> {
    public static final int DEFAULT_DATABASE_SHARD_COUNT = 2;
    public static final int DEFAULT_DATABASE_PORT = 12000;
    public static final String DEFAULT_DATABASE_NAME = "testcontainers";
    public static final RedisModule[] DEFAULT_DATABASE_MODULES = new RedisModule[]{RedisModule.JSON, RedisModule.SEARCH, RedisModule.TIMESERIES, RedisModule.BLOOM};
    private static final Logger log = LoggerFactory.getLogger(RedisEnterpriseContainer.class);
    private final Admin admin = new Admin();
    private Database database = RedisEnterpriseContainer.defaultDatabase();

    public static Database defaultDatabase() {
        return Database.builder().name(DEFAULT_DATABASE_NAME).shardCount(2).port(Integer.valueOf(12000)).ossCluster(true).modules(DEFAULT_DATABASE_MODULES).build();
    }

    public RedisEnterpriseContainer(String dockerImageName) {
        super(dockerImageName);
    }

    public RedisEnterpriseContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
    }

    public Database getDatabase() {
        return this.database;
    }

    public RedisEnterpriseContainer withDatabase(Database database) {
        this.database = database;
        if (database.getPort() == null) {
            database.setPort(Integer.valueOf(12000));
        }
        return this;
    }

    @Override
    protected String getAdminUserName() {
        return this.admin.getUserName();
    }

    @Override
    protected String getAdminPassword() {
        return this.admin.getPassword();
    }

    protected void doStart() {
        this.admin.withHost(this.getHost());
        this.addFixedExposedPort(this.admin.getPort(), this.admin.getPort());
        this.addFixedExposedPort(this.database.getPort(), this.database.getPort());
        super.doStart();
    }

    @Override
    protected void createCluster() throws Exception {
        log.info("Waiting for cluster bootstrap");
        this.admin.waitForBoostrap();
        super.createCluster();
        Database response = this.admin.createDatabase(this.database);
        log.info("Created database {} with UID {}", (Object)response.getName(), (Object)response.getUid());
    }

    @Override
    public boolean isRedisCluster() {
        return this.database.isOssCluster();
    }

    @Override
    public int getRedisPort() {
        return this.database.getPort();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.database);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RedisEnterpriseContainer other = (RedisEnterpriseContainer)obj;
        return Objects.equals(this.database, other.database);
    }
}

