/*
 * Decompiled with CFR 0.152.
 */
package io.rebloom.client;

import io.rebloom.client.Command;
import io.rebloom.client.InsertOptions;
import io.rebloom.client.Keywords;
import io.rebloom.client.TopKCommand;
import io.rebloom.client.cf.CFInsertOptions;
import io.rebloom.client.cf.CFReserveOptions;
import io.rebloom.client.cf.Cuckoo;
import io.rebloom.client.cf.CuckooCommand;
import io.rebloom.client.cms.CMS;
import io.rebloom.client.cms.CMSCommand;
import java.io.Closeable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.util.Pool;
import redis.clients.jedis.util.SafeEncoder;

public class Client
implements Cuckoo,
CMS,
Closeable {
    private final Pool<Jedis> pool;

    public Client(Pool<Jedis> pool) {
        this.pool = pool;
    }

    public Client(String host, int port, int timeout, int poolSize) {
        JedisPoolConfig conf = new JedisPoolConfig();
        conf.setMaxTotal(poolSize);
        conf.setTestOnBorrow(false);
        conf.setTestOnReturn(false);
        conf.setTestOnCreate(false);
        conf.setTestWhileIdle(false);
        conf.setMinEvictableIdleTimeMillis(60000L);
        conf.setTimeBetweenEvictionRunsMillis(30000L);
        conf.setNumTestsPerEvictionRun(-1);
        conf.setFairness(true);
        this.pool = new JedisPool((GenericObjectPoolConfig)conf, host, port, timeout);
    }

    public Client(String host, int port) {
        this(host, port, 500, 100);
    }

    public void createFilter(String name, long initCapacity, double errorRate) {
        try (Jedis conn = this._conn();){
            String rep = this.sendCommand(conn, (ProtocolCommand)Command.RESERVE, SafeEncoder.encode((String)name), Protocol.toByteArray((double)errorRate), Protocol.toByteArray((long)initCapacity)).getStatusCodeReply();
            if (!rep.equals("OK")) {
                throw new JedisException(rep);
            }
        }
    }

    public boolean add(String name, String value) {
        return this.add(name, SafeEncoder.encode((String)value));
    }

    public boolean add(String name, byte[] value) {
        try (Jedis conn = this._conn();){
            boolean bl = this.sendCommand(conn, (ProtocolCommand)Command.ADD, SafeEncoder.encode((String)name), value).getIntegerReply() != 0L;
            return bl;
        }
    }

    public boolean[] insert(String name, InsertOptions options, String ... items) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.addAll(options.getOptions());
        args.add(Keywords.ITEMS.getRaw());
        for (String item : items) {
            args.add(SafeEncoder.encode((String)item));
        }
        return this.sendMultiCommand(Command.INSERT, SafeEncoder.encode((String)name), (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    @SafeVarargs
    private final boolean[] sendMultiCommand(Command cmd, byte[] name, byte[] ... values) {
        List reps;
        byte[][] args = new byte[values.length + 1][];
        args[0] = name;
        System.arraycopy(values, 0, args, 1, values.length);
        try (Jedis conn = this._conn();){
            reps = this.sendCommand(conn, (ProtocolCommand)cmd, args).getIntegerMultiBulkReply();
        }
        boolean[] ret = new boolean[values.length];
        for (int i = 0; i < reps.size(); ++i) {
            ret[i] = (Long)reps.get(i) != 0L;
        }
        return ret;
    }

    public boolean[] addMulti(String name, byte[] ... values) {
        return this.sendMultiCommand(Command.MADD, SafeEncoder.encode((String)name), values);
    }

    public boolean[] addMulti(String name, String ... values) {
        return this.addMulti(name, SafeEncoder.encodeMany((String[])values));
    }

    public boolean exists(String name, String value) {
        return this.exists(name, SafeEncoder.encode((String)value));
    }

    public boolean exists(String name, byte[] value) {
        try (Jedis conn = this._conn();){
            boolean bl = this.sendCommand(conn, (ProtocolCommand)Command.EXISTS, SafeEncoder.encode((String)name), value).getIntegerReply() != 0L;
            return bl;
        }
    }

    public boolean[] existsMulti(String name, byte[] ... values) {
        return this.sendMultiCommand(Command.MEXISTS, SafeEncoder.encode((String)name), values);
    }

    public boolean[] existsMulti(String name, String ... values) {
        return this.sendMultiCommand(Command.MEXISTS, SafeEncoder.encode((String)name), SafeEncoder.encodeMany((String[])values));
    }

    public boolean delete(String name) {
        try (Jedis conn = this._conn();){
            boolean bl = conn.del(name) != 0L;
            return bl;
        }
    }

    public Map<String, Object> info(String name) {
        try (Jedis conn = this._conn();){
            List values = this.sendCommand(conn, (ProtocolCommand)Command.INFO, new byte[][]{SafeEncoder.encode((String)name)}).getObjectMultiBulkReply();
            HashMap<String, Object> infoMap = new HashMap<String, Object>(values.size() / 2);
            for (int i = 0; i < values.size(); i += 2) {
                Object val = values.get(i + 1);
                if (val instanceof byte[]) {
                    val = SafeEncoder.encode((byte[])((byte[])val));
                }
                infoMap.put(SafeEncoder.encode((byte[])((byte[])values.get(i))), val);
            }
            HashMap<String, Object> hashMap = infoMap;
            return hashMap;
        }
    }

    public void topkCreateFilter(String key, long topk, long width, long depth, double decay) {
        try (Jedis conn = this._conn();){
            String rep = this.sendCommand(conn, (ProtocolCommand)TopKCommand.RESERVE, SafeEncoder.encode((String)key), Protocol.toByteArray((long)topk), Protocol.toByteArray((long)width), Protocol.toByteArray((long)depth), Protocol.toByteArray((double)decay)).getStatusCodeReply();
            if (!rep.equals("OK")) {
                throw new JedisException(rep);
            }
        }
    }

    public List<String> topkAdd(String key, String ... items) {
        try (Jedis conn = this._conn();){
            List list = this.sendCommand(conn, key, TopKCommand.ADD, items).getMultiBulkReply();
            return list;
        }
    }

    public String topkIncrBy(String key, String item, long increment) {
        try (Jedis conn = this._conn();){
            String string = (String)this.sendCommand(conn, (ProtocolCommand)TopKCommand.INCRBY, SafeEncoder.encode((String)key), SafeEncoder.encode((String)item), Protocol.toByteArray((long)increment)).getMultiBulkReply().get(0);
            return string;
        }
    }

    public List<Boolean> topkQuery(String key, String ... items) {
        try (Jedis conn = this._conn();){
            List<Boolean> list = this.sendCommand(conn, key, TopKCommand.QUERY, items).getIntegerMultiBulkReply().stream().map(s -> s != 0L).collect(Collectors.toList());
            return list;
        }
    }

    public List<Long> topkCount(String key, String ... items) {
        try (Jedis conn = this._conn();){
            List list = this.sendCommand(conn, key, TopKCommand.COUNT, items).getIntegerMultiBulkReply();
            return list;
        }
    }

    public List<String> topkList(String key) {
        try (Jedis conn = this._conn();){
            List list = this.sendCommand(conn, (ProtocolCommand)TopKCommand.LIST, new byte[][]{SafeEncoder.encode((String)key)}).getMultiBulkReply();
            return list;
        }
    }

    @Override
    public void cmsInitByDim(String key, long width, long depth) {
        try (Jedis conn = this._conn();){
            String rep = this.sendCommand(conn, (ProtocolCommand)CMSCommand.INITBYDIM, SafeEncoder.encode((String)key), Protocol.toByteArray((long)width), Protocol.toByteArray((long)depth)).getStatusCodeReply();
            if (!rep.equals("OK")) {
                throw new JedisException(rep);
            }
        }
    }

    @Override
    public void cmsInitByProb(String key, double error, double probability) {
        try (Jedis conn = this._conn();){
            String rep = this.sendCommand(conn, (ProtocolCommand)CMSCommand.INITBYPROB, SafeEncoder.encode((String)key), Protocol.toByteArray((double)error), Protocol.toByteArray((double)probability)).getStatusCodeReply();
            if (!rep.equals("OK")) {
                throw new JedisException(rep);
            }
        }
    }

    @Override
    public long cmsIncrBy(String key, String item, long increment) {
        try (Jedis conn = this._conn();){
            long l = (Long)this.sendCommand(conn, (ProtocolCommand)CMSCommand.INCRBY, SafeEncoder.encode((String)key), SafeEncoder.encode((String)item), Protocol.toByteArray((long)increment)).getIntegerMultiBulkReply().get(0);
            return l;
        }
    }

    @Override
    public List<Long> cmsIncrBy(String key, Map<String, Long> itemIncrements) {
        try (Jedis conn = this._conn();){
            List mapFlatten = itemIncrements.entrySet().stream().flatMap(e -> Stream.of(SafeEncoder.encode((String)((String)e.getKey())), Protocol.toByteArray((long)((Long)e.getValue())))).collect(Collectors.toList());
            byte[][] fullArgs = new byte[mapFlatten.size() + 1][];
            fullArgs[0] = SafeEncoder.encode((String)key);
            System.arraycopy(mapFlatten.toArray(), 0, fullArgs, 1, mapFlatten.size());
            List list = this.sendCommand(conn, (ProtocolCommand)CMSCommand.INCRBY, fullArgs).getIntegerMultiBulkReply();
            return list;
        }
    }

    @Override
    public List<Long> cmsQuery(String key, String ... items) {
        try (Jedis conn = this._conn();){
            List list = this.sendCommand(conn, key, CMSCommand.QUERY, items).getIntegerMultiBulkReply();
            return list;
        }
    }

    @Override
    public void cmsMerge(String destKey, String ... keys) {
        try (Jedis conn = this._conn();){
            byte[][] args = new byte[keys.length + 2][];
            args[0] = SafeEncoder.encode((String)destKey);
            args[1] = Protocol.toByteArray((int)keys.length);
            System.arraycopy(SafeEncoder.encodeMany((String[])keys), 0, args, 2, keys.length);
            String rep = this.sendCommand(conn, (ProtocolCommand)CMSCommand.MERGE, args).getStatusCodeReply();
            if (!rep.equals("OK")) {
                throw new JedisException(rep);
            }
        }
    }

    @Override
    public void cmsMerge(String destKey, Map<String, Long> keysAndWeights) {
        try (Jedis conn = this._conn();){
            String[] keys = keysAndWeights.keySet().toArray(new String[0]);
            String[] weights = keysAndWeights.values().stream().map(l -> l.toString()).collect(Collectors.toList()).toArray(new String[0]);
            byte[][] args = new byte[keysAndWeights.size() * 2 + 3][];
            args[0] = SafeEncoder.encode((String)destKey);
            args[1] = Protocol.toByteArray((int)keys.length);
            System.arraycopy(SafeEncoder.encodeMany((String[])keys), 0, args, 2, keys.length);
            args[keys.length + 2] = SafeEncoder.encode((String)"WEIGHTS");
            System.arraycopy(SafeEncoder.encodeMany((String[])weights), 0, args, weights.length * 2 + 1, weights.length);
            String rep = this.sendCommand(conn, (ProtocolCommand)CMSCommand.MERGE, args).getStatusCodeReply();
            if (!rep.equals("OK")) {
                throw new JedisException(rep);
            }
        }
    }

    @Override
    public Map<String, Long> cmsInfo(String key) {
        try (Jedis conn = this._conn();){
            List values = this.sendCommand(conn, (ProtocolCommand)CMSCommand.INFO, new byte[][]{SafeEncoder.encode((String)key)}).getObjectMultiBulkReply();
            HashMap<String, Long> infoMap = new HashMap<String, Long>(values.size() / 2);
            for (int i = 0; i < values.size(); i += 2) {
                Long val = (Long)values.get(i + 1);
                infoMap.put(SafeEncoder.encode((byte[])((byte[])values.get(i))), val);
            }
            HashMap<String, Long> hashMap = infoMap;
            return hashMap;
        }
    }

    @Override
    public void close() {
        this.pool.close();
    }

    Jedis _conn() {
        return (Jedis)this.pool.getResource();
    }

    private Connection sendCommand(Jedis conn, String key, ProtocolCommand command, String ... args) {
        byte[][] fullArgs = new byte[args.length + 1][];
        fullArgs[0] = SafeEncoder.encode((String)key);
        System.arraycopy(SafeEncoder.encodeMany((String[])args), 0, fullArgs, 1, args.length);
        return this.sendCommand(conn, command, fullArgs);
    }

    private Connection sendCommand(Jedis conn, ProtocolCommand command, byte[] ... args) {
        redis.clients.jedis.Client client = conn.getClient();
        client.sendCommand(command, args);
        return client;
    }

    private Connection sendCommand(Jedis conn, ProtocolCommand command, List<byte[]> args) {
        redis.clients.jedis.Client client = conn.getClient();
        client.sendCommand(command, (byte[][])args.toArray((T[])new byte[args.size()][]));
        return client;
    }

    @Override
    public void cfCreate(String key, CFReserveOptions options) {
        try (Jedis conn = this._conn();){
            ArrayList<byte[]> fullArgs = new ArrayList<byte[]>();
            fullArgs.add(SafeEncoder.encode((String)key));
            fullArgs.addAll(options.asListOfByteArrays());
            String rep = this.sendCommand(conn, (ProtocolCommand)CuckooCommand.RESERVE, fullArgs).getStatusCodeReply();
            if (!rep.equals("OK")) {
                throw new JedisException(rep);
            }
        }
    }

    @Override
    public void cfCreate(String key, long capacity) {
        try (Jedis conn = this._conn();){
            String rep = this.sendCommand(conn, (ProtocolCommand)CuckooCommand.RESERVE, SafeEncoder.encode((String)key), Protocol.toByteArray((long)capacity)).getStatusCodeReply();
            if (!rep.equals("OK")) {
                throw new JedisException(rep);
            }
        }
    }

    @Override
    public boolean cfAdd(String key, String item) {
        try (Jedis conn = this._conn();){
            boolean bl = this.sendCommand(conn, (ProtocolCommand)CuckooCommand.ADD, SafeEncoder.encode((String)key), SafeEncoder.encode((String)item)).getIntegerReply() == 1L;
            return bl;
        }
    }

    @Override
    public boolean cfAddNx(String key, String item) {
        try (Jedis conn = this._conn();){
            boolean bl = this.sendCommand(conn, (ProtocolCommand)CuckooCommand.ADDNX, SafeEncoder.encode((String)key), SafeEncoder.encode((String)item)).getIntegerReply() == 1L;
            return bl;
        }
    }

    @Override
    public List<Boolean> cfInsert(String key, String ... items) {
        try (Jedis conn = this._conn();){
            ArrayList<byte[]> fullArgs = new ArrayList<byte[]>();
            fullArgs.add(SafeEncoder.encode((String)key));
            fullArgs.add(SafeEncoder.encode((String)"ITEMS"));
            fullArgs.addAll(Arrays.asList(SafeEncoder.encodeMany((String[])items)));
            List<Boolean> list = this.sendCommand(conn, (ProtocolCommand)CuckooCommand.INSERT, fullArgs).getIntegerMultiBulkReply().stream().map(s -> s > 0L).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<Boolean> cfInsert(String key, CFInsertOptions options, String ... items) {
        try (Jedis conn = this._conn();){
            ArrayList<byte[]> fullArgs = new ArrayList<byte[]>();
            fullArgs.add(SafeEncoder.encode((String)key));
            fullArgs.addAll(options.asListOfByteArrays());
            fullArgs.add(SafeEncoder.encode((String)"ITEMS"));
            fullArgs.addAll(Arrays.asList(SafeEncoder.encodeMany((String[])items)));
            List<Boolean> list = this.sendCommand(conn, (ProtocolCommand)CuckooCommand.INSERT, fullArgs).getIntegerMultiBulkReply().stream().map(s -> s > 0L).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<Boolean> cfInsertNx(String key, String ... items) {
        try (Jedis conn = this._conn();){
            ArrayList<byte[]> fullArgs = new ArrayList<byte[]>();
            fullArgs.add(SafeEncoder.encode((String)key));
            fullArgs.add(SafeEncoder.encode((String)"ITEMS"));
            fullArgs.addAll(Arrays.asList(SafeEncoder.encodeMany((String[])items)));
            List<Boolean> list = this.sendCommand(conn, (ProtocolCommand)CuckooCommand.INSERTNX, fullArgs).getIntegerMultiBulkReply().stream().map(s -> s > 0L).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<Boolean> cfInsertNx(String key, CFInsertOptions options, String ... items) {
        try (Jedis conn = this._conn();){
            ArrayList<byte[]> fullArgs = new ArrayList<byte[]>();
            fullArgs.add(SafeEncoder.encode((String)key));
            fullArgs.addAll(options.asListOfByteArrays());
            fullArgs.add(SafeEncoder.encode((String)"ITEMS"));
            fullArgs.addAll(Arrays.asList(SafeEncoder.encodeMany((String[])items)));
            List<Boolean> list = this.sendCommand(conn, (ProtocolCommand)CuckooCommand.INSERTNX, fullArgs).getIntegerMultiBulkReply().stream().map(s -> s > 0L).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public boolean cfExists(String key, String item) {
        try (Jedis conn = this._conn();){
            boolean bl = this.sendCommand(conn, (ProtocolCommand)CuckooCommand.EXIST, SafeEncoder.encode((String)key), SafeEncoder.encode((String)item)).getIntegerReply() == 1L;
            return bl;
        }
    }

    @Override
    public boolean cfDel(String key, String item) {
        try (Jedis conn = this._conn();){
            boolean bl = this.sendCommand(conn, (ProtocolCommand)CuckooCommand.DEL, SafeEncoder.encode((String)key), SafeEncoder.encode((String)item)).getIntegerReply() == 1L;
            return bl;
        }
    }

    @Override
    public long cfCount(String key, String item) {
        try (Jedis conn = this._conn();){
            long l = this.sendCommand(conn, (ProtocolCommand)CuckooCommand.COUNT, SafeEncoder.encode((String)key), SafeEncoder.encode((String)item)).getIntegerReply();
            return l;
        }
    }

    @Override
    public Map.Entry<Long, byte[]> cfScanDump(String key, long iterator) {
        try (Jedis conn = this._conn();){
            List response = this.sendCommand(conn, (ProtocolCommand)CuckooCommand.SCANDUMP, SafeEncoder.encode((String)key), Protocol.toByteArray((long)iterator)).getObjectMultiBulkReply();
            AbstractMap.SimpleImmutableEntry<Long, byte[]> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Long, byte[]>((Long)response.get(0), (byte[])response.get(1));
            return simpleImmutableEntry;
        }
    }

    @Override
    public void cfLoadChunk(String key, Map.Entry<Long, byte[]> idp) {
        try (Jedis conn = this._conn();){
            String rep = this.sendCommand(conn, (ProtocolCommand)CuckooCommand.LOADCHUNK, SafeEncoder.encode((String)key), Protocol.toByteArray((long)idp.getKey()), idp.getValue()).getStatusCodeReply();
            if (!rep.equals("OK")) {
                throw new JedisException(rep);
            }
        }
    }

    @Override
    public Map<String, Long> cfInfo(String key) {
        try (Jedis conn = this._conn();){
            List values = this.sendCommand(conn, (ProtocolCommand)CuckooCommand.INFO, new byte[][]{SafeEncoder.encode((String)key)}).getObjectMultiBulkReply();
            HashMap<String, Long> infoMap = new HashMap<String, Long>(values.size() / 2);
            for (int i = 0; i < values.size(); i += 2) {
                Long val = (Long)values.get(i + 1);
                infoMap.put(SafeEncoder.encode((byte[])((byte[])values.get(i))), val);
            }
            HashMap<String, Long> hashMap = infoMap;
            return hashMap;
        }
    }

    @Override
    public Iterator<Map.Entry<Long, byte[]>> cfScanDumpIterator(String key) {
        return new CfScanDumpIterator(this, key);
    }

    @Override
    public Stream<Map.Entry<Long, byte[]>> cfScanDumpStream(String key) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new CfScanDumpIterator(this, key), 16), false);
    }

    private static class CfScanDumpIterator
    implements Iterator<Map.Entry<Long, byte[]>> {
        private final Client client;
        private final String key;
        private Long current;

        public CfScanDumpIterator(Client client, String key) {
            this.client = client;
            this.key = key;
        }

        @Override
        public boolean hasNext() {
            return this.scan(this.current) != null;
        }

        @Override
        public Map.Entry<Long, byte[]> next() {
            Map.Entry<Long, byte[]> dump = this.scan(this.current);
            this.current = dump == null ? Long.valueOf(0L) : dump.getKey();
            return dump;
        }

        private Map.Entry<Long, byte[]> scan(Long iter) {
            Map.Entry<Long, byte[]> dump = this.client.cfScanDump(this.key, iter == null ? 0L : iter);
            return dump.getKey() != 0L ? dump : null;
        }
    }
}

