/*
 * Decompiled with CFR 0.152.
 */
package io.rebloom.client;

import io.rebloom.client.Command;
import io.rebloom.client.InsertOptions;
import io.rebloom.client.Keywords;
import io.rebloom.client.TopKCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Client;
import redis.clients.jedis.Connection;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisClusterCommand;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.util.SafeEncoder;

public class ClusterClient
extends JedisCluster {
    public ClusterClient(HostAndPort node) {
        super(node);
    }

    public ClusterClient(HostAndPort node, int timeout) {
        super(node, timeout);
    }

    public ClusterClient(HostAndPort node, int timeout, int maxAttempts) {
        super(node, timeout, maxAttempts);
    }

    public ClusterClient(HostAndPort node, GenericObjectPoolConfig poolConfig) {
        super(node, poolConfig);
    }

    public ClusterClient(HostAndPort node, int timeout, GenericObjectPoolConfig poolConfig) {
        super(node, timeout, poolConfig);
    }

    public ClusterClient(HostAndPort node, int timeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(node, timeout, maxAttempts, poolConfig);
    }

    public ClusterClient(HostAndPort node, int connectionTimeout, int soTimeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(node, connectionTimeout, soTimeout, maxAttempts, poolConfig);
    }

    public ClusterClient(HostAndPort node, int connectionTimeout, int soTimeout, int maxAttempts, String password, GenericObjectPoolConfig poolConfig) {
        super(node, connectionTimeout, soTimeout, maxAttempts, password, poolConfig);
    }

    public ClusterClient(HostAndPort node, int connectionTimeout, int soTimeout, int maxAttempts, String password, String clientName, GenericObjectPoolConfig poolConfig) {
        super(node, connectionTimeout, soTimeout, maxAttempts, password, clientName, poolConfig);
    }

    public ClusterClient(Set<HostAndPort> nodes) {
        super(nodes);
    }

    public ClusterClient(Set<HostAndPort> nodes, int timeout) {
        super(nodes, timeout);
    }

    public ClusterClient(Set<HostAndPort> nodes, int timeout, int maxAttempts) {
        super(nodes, timeout, maxAttempts);
    }

    public ClusterClient(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig) {
        super(nodes, poolConfig);
    }

    public ClusterClient(Set<HostAndPort> nodes, int timeout, GenericObjectPoolConfig poolConfig) {
        super(nodes, timeout, poolConfig);
    }

    public ClusterClient(Set<HostAndPort> jedisClusterNode, int timeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(jedisClusterNode, timeout, maxAttempts, poolConfig);
    }

    public ClusterClient(Set<HostAndPort> jedisClusterNode, int connectionTimeout, int soTimeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(jedisClusterNode, connectionTimeout, soTimeout, maxAttempts, poolConfig);
    }

    public ClusterClient(Set<HostAndPort> jedisClusterNode, int connectionTimeout, int soTimeout, int maxAttempts, String password, GenericObjectPoolConfig poolConfig) {
        super(jedisClusterNode, connectionTimeout, soTimeout, maxAttempts, password, poolConfig);
    }

    public ClusterClient(Set<HostAndPort> jedisClusterNode, int connectionTimeout, int soTimeout, int maxAttempts, String password, String clientName, GenericObjectPoolConfig poolConfig) {
        super(jedisClusterNode, connectionTimeout, soTimeout, maxAttempts, password, clientName, poolConfig);
    }

    private void sendCommand(Connection conn, String key, ProtocolCommand command, String ... args) {
        String[] fullArgs = new String[args.length + 1];
        fullArgs[0] = key;
        System.arraycopy(args, 0, fullArgs, 1, args.length);
        conn.sendCommand(command, fullArgs);
    }

    public boolean createFilter(final String name, final long initCapacity, final double errorRate) {
        return (Boolean)new JedisClusterCommand<Boolean>(this.connectionHandler, this.maxAttempts){

            public Boolean execute(Jedis connection) {
                Client conn = connection.getClient();
                conn.sendCommand((ProtocolCommand)Command.RESERVE, new String[]{name, errorRate + "", initCapacity + ""});
                return conn.getStatusCodeReply().equals("OK");
            }
        }.run(name);
    }

    public boolean add(String name, String value) {
        return this.add(name, SafeEncoder.encode((String)value));
    }

    public boolean add(final String name, final byte[] value) {
        return (Boolean)new JedisClusterCommand<Boolean>(this.connectionHandler, this.maxAttempts){

            public Boolean execute(Jedis connection) {
                Client conn = connection.getClient();
                conn.sendCommand((ProtocolCommand)Command.ADD, (byte[][])new byte[][]{name.getBytes(), value});
                return conn.getIntegerReply() != 0L;
            }
        }.run(name);
    }

    public boolean[] insert(final String name, final InsertOptions options, final String ... items) {
        return (boolean[])new JedisClusterCommand<boolean[]>(this.connectionHandler, this.maxAttempts){

            public boolean[] execute(Jedis connection) {
                Client conn = connection.getClient();
                ArrayList<byte[]> args = new ArrayList<byte[]>();
                args.addAll(options.getOptions());
                args.add(Keywords.ITEMS.getRaw());
                for (String item : items) {
                    args.add(SafeEncoder.encode((String)item));
                }
                return ClusterClient.this.sendMultiCommand((Connection)conn, Command.INSERT, name.getBytes(), args.toArray((T[])new byte[args.size()][]));
            }
        }.run(name);
    }

    public boolean exists(String name, String value) {
        return this.exists(name, SafeEncoder.encode((String)value));
    }

    public boolean exists(final String name, final byte[] value) {
        return (Boolean)new JedisClusterCommand<Boolean>(this.connectionHandler, this.maxAttempts){

            public Boolean execute(Jedis connection) {
                Client conn = connection.getClient();
                conn.sendCommand((ProtocolCommand)Command.EXISTS, (byte[][])new byte[][]{name.getBytes(), value});
                return conn.getIntegerReply() != 0L;
            }
        }.run(name);
    }

    public boolean[] addMulti(final String name, final byte[] ... values) {
        return (boolean[])new JedisClusterCommand<boolean[]>(this.connectionHandler, this.maxAttempts){

            public boolean[] execute(Jedis connection) {
                Client conn = connection.getClient();
                return ClusterClient.this.sendMultiCommand((Connection)conn, Command.MADD, name.getBytes(), (Object[])values);
            }
        }.run(name);
    }

    public boolean[] addMulti(final String name, final String ... values) {
        return (boolean[])new JedisClusterCommand<boolean[]>(this.connectionHandler, this.maxAttempts){

            public boolean[] execute(Jedis connection) {
                Client conn = connection.getClient();
                return ClusterClient.this.sendMultiCommand((Connection)conn, Command.MADD, name, values);
            }
        }.run(name);
    }

    public boolean[] existsMulti(final String name, final byte[] ... values) {
        return (boolean[])new JedisClusterCommand<boolean[]>(this.connectionHandler, this.maxAttempts){

            public boolean[] execute(Jedis connection) {
                Client conn = connection.getClient();
                return ClusterClient.this.sendMultiCommand((Connection)conn, Command.MEXISTS, name.getBytes(), (Object[])values);
            }
        }.run(name);
    }

    public boolean[] existsMulti(final String name, final String ... values) {
        return (boolean[])new JedisClusterCommand<boolean[]>(this.connectionHandler, this.maxAttempts){

            public boolean[] execute(Jedis connection) {
                Client conn = connection.getClient();
                return ClusterClient.this.sendMultiCommand((Connection)conn, Command.MEXISTS, name, values);
            }
        }.run(name);
    }

    public boolean delete(final String name) {
        return (Boolean)new JedisClusterCommand<Boolean>(this.connectionHandler, this.maxAttempts){

            public Boolean execute(Jedis connection) {
                Client conn = connection.getClient();
                conn.del(new String[]{name});
                return conn.getIntegerReply() != 0L;
            }
        }.run(name);
    }

    public Map<String, Object> info(final String name) {
        return (Map)new JedisClusterCommand<Map<String, Object>>(this.connectionHandler, this.maxAttempts){

            public Map<String, Object> execute(Jedis connection) {
                Client conn = connection.getClient();
                conn.sendCommand((ProtocolCommand)Command.INFO, (byte[][])new byte[][]{name.getBytes()});
                List values = conn.getObjectMultiBulkReply();
                HashMap<String, Object> infoMap = new HashMap<String, Object>(values.size() / 2);
                for (int i = 0; i < values.size(); i += 2) {
                    Object val = values.get(i + 1);
                    if (val instanceof byte[]) {
                        val = SafeEncoder.encode((byte[])((byte[])val));
                    }
                    infoMap.put(SafeEncoder.encode((byte[])((byte[])values.get(i))), val);
                }
                return infoMap;
            }
        }.run(name);
    }

    public void topkCreateFilter(final String key, final long topk, final long width, final long depth, final double decay) {
        new JedisClusterCommand<Void>(this.connectionHandler, this.maxAttempts){

            public Void execute(Jedis jedis) {
                Client conn = jedis.getClient();
                conn.sendCommand((ProtocolCommand)TopKCommand.RESERVE, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((long)topk), Protocol.toByteArray((long)width), Protocol.toByteArray((long)depth), Protocol.toByteArray((double)decay)});
                String resp = conn.getStatusCodeReply();
                if (!resp.equals("OK")) {
                    throw new JedisException(resp);
                }
                return null;
            }
        }.run(key);
    }

    public List<String> topkAdd(final String key, final String ... items) {
        return (List)new JedisClusterCommand<List<String>>(this.connectionHandler, this.maxAttempts){

            public List<String> execute(Jedis jedis) {
                Client conn = jedis.getClient();
                ClusterClient.this.sendCommand((Connection)conn, key, TopKCommand.ADD, items);
                return conn.getMultiBulkReply();
            }
        }.run(key);
    }

    public String topkIncrBy(final String key, final String item, final long increment) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.maxAttempts){

            public String execute(Jedis jedis) {
                Client conn = jedis.getClient();
                conn.sendCommand((ProtocolCommand)TopKCommand.INCRBY, (byte[][])new byte[][]{SafeEncoder.encode((String)key), SafeEncoder.encode((String)item), Protocol.toByteArray((long)increment)});
                return (String)conn.getMultiBulkReply().get(0);
            }
        }.run(key);
    }

    public List<Boolean> topkQuery(final String key, final String ... items) {
        return (List)new JedisClusterCommand<List<Boolean>>(this.connectionHandler, this.maxAttempts){

            public List<Boolean> execute(Jedis jedis) {
                Client conn = jedis.getClient();
                ClusterClient.this.sendCommand((Connection)conn, key, TopKCommand.QUERY, items);
                return conn.getIntegerMultiBulkReply().stream().map(s -> s != 0L).collect(Collectors.toList());
            }
        }.run(key);
    }

    public List<Long> topkCount(final String key, final String ... items) {
        return (List)new JedisClusterCommand<List<Long>>(this.connectionHandler, this.maxAttempts){

            public List<Long> execute(Jedis jedis) {
                Client conn = jedis.getClient();
                ClusterClient.this.sendCommand((Connection)conn, key, TopKCommand.COUNT, items);
                return conn.getIntegerMultiBulkReply();
            }
        }.run(key);
    }

    public List<String> topkList(final String key) {
        return (List)new JedisClusterCommand<List<String>>(this.connectionHandler, this.maxAttempts){

            public List<String> execute(Jedis jedis) {
                Client conn = jedis.getClient();
                conn.sendCommand((ProtocolCommand)TopKCommand.LIST, new String[]{key});
                return conn.getMultiBulkReply();
            }
        }.run(key);
    }

    @SafeVarargs
    private final <T> boolean[] sendMultiCommand(Connection conn, Command cmd, T name, T ... value) {
        List reps;
        ArrayList<T> arr = new ArrayList<T>();
        arr.add(name);
        arr.addAll(Arrays.asList(value));
        if (name instanceof String) {
            conn.sendCommand((ProtocolCommand)cmd, arr.toArray((String[])value));
            reps = conn.getIntegerMultiBulkReply();
        } else {
            conn.sendCommand((ProtocolCommand)cmd, (byte[][])arr.toArray((T[])((byte[][])value)));
            reps = conn.getIntegerMultiBulkReply();
        }
        boolean[] ret = new boolean[value.length];
        for (int i = 0; i < reps.size(); ++i) {
            ret[i] = (Long)reps.get(i) != 0L;
        }
        return ret;
    }
}

