/*
 * Decompiled with CFR 0.152.
 */
package io.rebloom.client.cf;

import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.util.SafeEncoder;

public class CFInsertOptions {
    private long capacity = -1L;
    private boolean noCreate = false;

    protected CFInsertOptions() {
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public boolean isNoCreate() {
        return this.noCreate;
    }

    public void setNoCreate(boolean noCreate) {
        this.noCreate = noCreate;
    }

    public List<byte[]> asListOfByteArrays() {
        ArrayList<byte[]> options = new ArrayList<byte[]>();
        if (this.capacity != -1L) {
            options.add(SafeEncoder.encode((String)"CAPACITY"));
            options.add(Protocol.toByteArray((long)this.capacity));
        }
        if (this.noCreate) {
            options.add(SafeEncoder.encode((String)"NOCREATE"));
        }
        return options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private CFInsertOptions options = new CFInsertOptions();

        public Builder withCapacity(long capacity) {
            this.options.setCapacity(capacity);
            return this;
        }

        public Builder noCreate() {
            this.options.setNoCreate(true);
            return this;
        }

        public CFInsertOptions build() {
            return this.options;
        }
    }
}

