/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security;

import javax.annotation.Nonnull;

import lombok.Data;
import lombok.Getter;

/**
 * Class that represents an authorization of a user.
 *
 * <ul>
 * <li>On SAP Cloud Platform Neo, authorizations correspond to roles.</li>
 * <li>On SAP Cloud Platform Cloud Foundry, authorizations correspond to scopes.</li>
 * </ul>
 */
@Data
public class Authorization
{
    /**
     * The name of this authorization.
     */
    @Getter
    @Nonnull
    private final String name;

    @Override
    @Nonnull
    public String toString()
    {
        return name;
    }
}
