/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security;

import javax.annotation.Nonnull;

import lombok.Data;

/**
 * Simple credential implementation based on a username and password.
 */
@Data
public class BasicCredentials implements Credentials
{
    @Nonnull
    private final String username;

    @Nonnull
    private final String password;

    /**
     * {@inheritDoc}
     */
    @Override
    @Nonnull
    public String toString()
    {
        return "BasicCredentials(username=" + username + ", password=(hidden))";
    }
}
