/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security;

import javax.annotation.Nonnull;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * {@code Authorization} implementation based on a tenant identifier and another {@code Authorization}.
 */
@EqualsAndHashCode( callSuper = true )
@Data
public class TenantSpecificAuthorization extends Authorization
{
    /**
     * The tenant identifier.
     */
    @Nonnull
    protected final String tenantId;

    /**
     * The wrapped authorization.
     */
    @Nonnull
    protected final Authorization authorization;

    /**
     * Creates a new authorization based on the tenant identifier and another {@code Authorization}.
     *
     * @param tenantId
     *            The tenant identifier of this {@code Authorization}.
     * @param authorization
     *            The {@code Authorization} to be considered tenant-specific.
     */
    public TenantSpecificAuthorization( @Nonnull final String tenantId, @Nonnull final Authorization authorization )
    {
        super(tenantId + ":" + authorization.getName());

        this.tenantId = tenantId;
        this.authorization = authorization;
    }
}
