/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.principal;

import java.util.Collection;

import javax.annotation.Nonnull;

import lombok.Data;

/**
 * A {@link PrincipalAttribute} holding a generic collection of values.
 * 
 * @param <T>
 *            The type of the collection.
 */
@Data
public class CollectionPrincipalAttribute<T> implements PrincipalAttribute
{
    @Nonnull
    private final String name;

    @Nonnull
    private final Collection<T> values;
}
