/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.principal;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.cloudplatform.thread.Property;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextAccessor;

import io.vavr.control.Try;

/**
 * Default implementation of {@link PrincipalFacade} encapsulating the logic to access {@link Principal} information.
 */
public class DefaultPrincipalFacade implements PrincipalFacade
{
    /**
     * {@inheritDoc}
     */
    @Override
    @Nonnull
    public Try<Principal> tryGetCurrentPrincipal()
    {
        return ThreadContextAccessor
            .tryGetCurrentContext()
            .flatMap(context -> context.<Principal> getProperty(PrincipalThreadContextListener.PROPERTY_PRINCIPAL))
            .map(Property::getValue);
    }
}
