/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.principal;

import javax.annotation.Nonnull;

/**
 * A simple attribute of a {@link Principal}.
 * <p>
 * An attribute of a user is identified by its name. By this name it can be identified in the
 * {@link Principal#getAttribute(String)} method.
 */
public interface PrincipalAttribute
{
    /**
     * The name that identifies this attribute.
     * 
     * @return The identifying attribute name.
     */
    @Nonnull
    String getName();
}
