/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.principal;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import lombok.Data;

/**
 * A {@link PrincipalAttribute} holding a simple generic value.
 *
 * @param <T>
 *            The type of the attribute.
 */
@Data
public class SimplePrincipalAttribute<T> implements PrincipalAttribute
{
    @Nonnull
    private final String name;

    @Nullable
    private final T value;
}
