/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.principal;

import java.util.Collection;

import javax.annotation.Nonnull;

/**
 * A {@link CollectionPrincipalAttribute} holding String values.
 */
public class StringCollectionPrincipalAttribute extends CollectionPrincipalAttribute<String>
{
    /**
     * Creates an {@link CollectionPrincipalAttribute} containing String values.
     *
     * @param name
     *            The name of this CollectionUserAttribute.
     * @param values
     *            The values of this attribute.
     */
    public StringCollectionPrincipalAttribute( @Nonnull final String name, @Nonnull final Collection<String> values )
    {
        super(name, values);
    }
}
